/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.block.IBlockPosQuery;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FleshTendonFeature
extends Feature<NoFeatureConfig> {
    protected IBlockPosQuery replace = (world, pos) -> world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos) || world.func_180495_p(pos).func_177230_c() == BOPBlocks.nether_crystal;
    private static final int MIN_DISTANCE = 8;
    private static final int MAX_DISTANCE = 32;
    private static final float MID_POS_MULTIPLIER = 0.9f;
    private static final float TENDON_STEP = 0.005f;

    public FleshTendonFeature(Codec<NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    private static BlockPos quadratic(float t, BlockPos v0, BlockPos v1, BlockPos v2) {
        float dt = 1.0f - t;
        Vector3d v = new Vector3d((double)v0.func_177958_n(), (double)v0.func_177956_o(), (double)v0.func_177952_p()).func_186678_a((double)(dt * dt)).func_178787_e(new Vector3d((double)v1.func_177958_n(), (double)v1.func_177956_o(), (double)v1.func_177952_p()).func_186678_a((double)(2.0f * dt * t))).func_178787_e(new Vector3d((double)v2.func_177958_n(), (double)v2.func_177956_o(), (double)v2.func_177952_p()).func_186678_a((double)(t * t)));
        return new BlockPos(v.field_72450_a, v.field_72448_b, v.field_72449_c);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos curPos;
        BlockState below = world.func_180495_p(pos.func_177977_b());
        if (!below.func_203425_a(BOPBlocks.flesh)) {
            return false;
        }
        int xOff = rand.nextInt(64) - 32;
        int zOff = rand.nextInt(64) - 32;
        int minX = rand.nextBoolean() ? 8 : -8;
        int minZ = rand.nextBoolean() ? 8 : -8;
        BlockPos endPos = pos.func_177982_a(Math.abs(xOff) < 8 ? minX : xOff, pos.func_177956_o(), Math.abs(zOff) < 8 ? minZ : zOff);
        while (world.func_175623_d(endPos) && endPos.func_177956_o() < 126) {
            endPos = endPos.func_177984_a();
        }
        if (endPos.func_177956_o() == pos.func_177956_o()) {
            return false;
        }
        BlockPos midPos = endPos.func_177963_a(0.0, (double)((float)(-(endPos.func_177956_o() - pos.func_177956_o())) * 0.9f), 0.0);
        for (float d = 0.0f; d < 1.0f && (curPos = FleshTendonFeature.quadratic(d, pos, midPos, endPos)).func_177956_o() < 126; d += 0.005f) {
            this.setBlock((IWorld)world, curPos, BOPBlocks.flesh.func_176223_P());
            if (rand.nextInt(75) != 0) continue;
            this.generateFleshBall(world, curPos, rand);
        }
        return true;
    }

    public boolean generateFleshBall(ISeedReader world, BlockPos pos, Random rand) {
        this.setBlock((IWorld)world, pos, BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177978_c(), Blocks.field_235383_mw_.func_176223_P(), 2);
        this.setBlock((IWorld)world, pos.func_177968_d(), Blocks.field_235383_mw_.func_176223_P(), 2);
        this.setBlock((IWorld)world, pos.func_177974_f(), Blocks.field_235383_mw_.func_176223_P(), 2);
        this.setBlock((IWorld)world, pos.func_177976_e(), Blocks.field_235383_mw_.func_176223_P(), 2);
        this.setBlock((IWorld)world, pos.func_177978_c().func_177976_e(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177968_d().func_177976_e(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177978_c().func_177974_f(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177968_d().func_177974_f(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177984_a(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177984_a().func_177978_c(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177984_a().func_177968_d(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177984_a().func_177974_f(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177984_a().func_177976_e(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177977_b(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177977_b().func_177978_c(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177977_b().func_177968_d(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177977_b().func_177974_f(), BOPBlocks.flesh.func_176223_P());
        this.setBlock((IWorld)world, pos.func_177977_b().func_177976_e(), BOPBlocks.flesh.func_176223_P());
        return true;
    }

    public boolean setBlock(IWorld world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.func_230367_a_((IWorldWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean setBlock(IWorld world, BlockPos pos, BlockState state, int flags) {
        if (this.replace.matches(world, pos)) {
            world.func_180501_a(pos, state, flags);
            return true;
        }
        return false;
    }
}

