/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.particles;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.effects.particles.RippleStyle;
import org.orecruncher.lib.biomes.BiomeUtilities;
import org.orecruncher.lib.gui.Color;
import org.orecruncher.lib.particles.AgeableMote;

@OnlyIn(value=Dist.CLIENT)
public class MoteWaterRipple
extends AgeableMote {
    private static final float TEX_SIZE_HALF = 0.5f;
    protected final float growthRate;
    protected float scale;
    protected float scaledWidth;
    protected float texU1;
    protected float texU2;
    protected float texV1;
    protected float texV2;

    public MoteWaterRipple(IBlockReader world, double x, double y, double z) {
        super(world, x, y, z);
        RippleStyle style = (RippleStyle)((Object)Config.CLIENT.effects.waterRippleStyle.get());
        this.maxAge = style.getMaxAge();
        if (style.doScaling()) {
            this.scale = this.growthRate = (float)this.maxAge / 500.0f;
            this.scaledWidth = this.scale * 0.5f;
        } else {
            this.growthRate = 0.0f;
            this.scale = 0.0f;
            this.scaledWidth = 0.5f;
        }
        this.posY -= 0.2;
        Color waterColor = BiomeUtilities.getColorForLiquid(world, this.position.func_177977_b());
        this.red = waterColor.red();
        this.green = waterColor.green();
        this.blue = waterColor.blue();
        this.alpha = 0.99f;
        this.texU1 = style.getU1(this.age);
        this.texU2 = style.getU2(this.age);
        this.texV1 = style.getV1(this.age);
        this.texV2 = style.getV2(this.age);
    }

    @Override
    public void update() {
        RippleStyle style = (RippleStyle)((Object)Config.CLIENT.effects.waterRippleStyle.get());
        if (style.doScaling()) {
            this.scale += this.growthRate;
            this.scaledWidth = this.scale * 0.5f;
        }
        if (style.doAlpha()) {
            this.alpha = (float)(this.maxAge - this.age) / (float)(this.maxAge + 3);
        }
        this.texU1 = style.getU1(this.age);
        this.texU2 = style.getU2(this.age);
        this.texV1 = style.getV1(this.age);
        this.texV2 = style.getV2(this.age);
    }

    @Override
    public void renderParticle(@Nonnull IVertexBuilder buffer, @Nonnull ActiveRenderInfo info, float partialTicks) {
        float x = this.renderX(info, partialTicks);
        float y = this.renderY(info, partialTicks);
        float z = this.renderZ(info, partialTicks);
        this.drawVertex(buffer, -this.scaledWidth + x, y, this.scaledWidth + z, this.texU2, this.texV2);
        this.drawVertex(buffer, this.scaledWidth + x, y, this.scaledWidth + z, this.texU2, this.texV1);
        this.drawVertex(buffer, this.scaledWidth + x, y, -this.scaledWidth + z, this.texU1, this.texV1);
        this.drawVertex(buffer, -this.scaledWidth + x, y, -this.scaledWidth + z, this.texU1, this.texV2);
    }
}

