/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.fml;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import org.orecruncher.lib.fml.Checker;
import org.orecruncher.lib.fml.ForgeUtils;

@OnlyIn(value=Dist.CLIENT)
public class UpdateChecker
extends Checker {
    protected final String messageId;

    public UpdateChecker(@Nonnull String modId) {
        this(modId, modId + ".msg.NewVersion");
    }

    public UpdateChecker(@Nonnull String id, @Nonnull String messageId) {
        super(id);
        this.messageId = messageId;
    }

    @Nullable
    private String getUpdateMessage(@Nonnull String modId) {
        Optional<IModInfo> mod = ForgeUtils.getModInfo(modId);
        if (!mod.isPresent()) {
            return null;
        }
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)mod.get());
        if (result.status != VersionChecker.Status.OUTDATED) {
            return null;
        }
        String t = result.target != null ? result.target.toString() : "UNKNOWN";
        String u = result.url != null ? result.url : "UNKNOWN";
        return I18n.func_135052_a((String)this.messageId, (Object[])new Object[]{mod.get().getDisplayName(), t, u});
    }

    @Override
    @Nullable
    public ITextComponent onClientLogin(@Nonnull ClientPlayerEntity player) {
        String updateMessage = this.getUpdateMessage(this.modId);
        if (updateMessage != null) {
            try {
                return ITextComponent.Serializer.func_240643_a_((String)updateMessage);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }
}

