/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.particles;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.particles.IParticleMote;

@OnlyIn(value=Dist.CLIENT)
public abstract class Mote
implements IParticleMote {
    protected final IBlockReader world;
    protected final IWorldReader lighting;
    protected boolean isAlive = true;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected final BlockPos.Mutable position = new BlockPos.Mutable();
    protected int packedLighting;
    protected float red;
    protected float green;
    protected float blue;
    protected float alpha;

    public Mote(@Nonnull IBlockReader world, double x, double y, double z) {
        this.world = world;
        this.lighting = world instanceof IWorldReader ? (IWorldReader)world : GameUtils.getWorld();
        this.setPosition(x, y, z);
        this.configureColor();
    }

    public void setPosition(double posX, double posY, double posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.position.func_189532_c(posX, posY, posZ);
    }

    @Override
    @Nonnull
    public Vector3d getPosition() {
        return new Vector3d(this.posX, this.posY, this.posZ);
    }

    public void configureColor() {
        this.alpha = 1.0f;
        this.blue = 1.0f;
        this.green = 1.0f;
        this.red = 1.0f;
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    @Override
    public void kill() {
        this.isAlive = false;
    }

    @Override
    public boolean tick() {
        if (this.isAlive()) {
            this.update();
            if (this.isAlive()) {
                this.setPosition(this.posX, this.posY, this.posZ);
                this.updateBrightness();
            }
        }
        return this.isAlive();
    }

    protected void update() {
    }

    public void updateBrightness() {
        this.packedLighting = WorldRenderer.func_228421_a_((IBlockDisplayReader)this.lighting, (BlockPos)this.position);
    }

    protected final double interpX(ActiveRenderInfo info) {
        return info.func_216785_c().field_72450_a;
    }

    protected final double interpY(ActiveRenderInfo info) {
        return info.func_216785_c().field_72448_b;
    }

    protected final double interpZ(ActiveRenderInfo info) {
        return info.func_216785_c().field_72449_c;
    }

    protected float renderX(ActiveRenderInfo info, float partialTicks) {
        return (float)(this.posX - this.interpX(info));
    }

    protected float renderY(ActiveRenderInfo info, float partialTicks) {
        return (float)(this.posY - this.interpY(info));
    }

    protected float renderZ(ActiveRenderInfo info, float partialTicks) {
        return (float)(this.posZ - this.interpZ(info));
    }

    protected void drawVertex(IVertexBuilder buffer, double x, double y, double z, float u, float v) {
        buffer.func_225582_a_(x, y, z).func_225583_a_(u, v).func_227885_a_(this.red, this.green, this.blue, this.alpha).func_227886_a_(this.packedLighting).func_181675_d();
    }

    @Override
    public abstract void renderParticle(@Nonnull IVertexBuilder var1, @Nonnull ActiveRenderInfo var2, float var3);
}

