/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps.facade;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.orecruncher.mobeffects.MobEffects;
import org.orecruncher.mobeffects.footsteps.facade.ChiselFacadeAccessor;
import org.orecruncher.mobeffects.footsteps.facade.IFacadeAccessor;

@OnlyIn(value=Dist.CLIENT)
public final class FacadeHelper {
    private static final Map<Block, IFacadeAccessor> crackers = new Reference2ObjectOpenHashMap();

    private static void addAccessor(@Nonnull List<IFacadeAccessor> accessors, @Nonnull IFacadeAccessor accessor) {
        if (accessor.isValid()) {
            MobEffects.LOGGER.info("Facade Accessor: %s", accessor.getName());
            accessors.add(accessor);
        }
    }

    protected FacadeHelper() {
    }

    @Nonnull
    public static BlockState resolveState(@Nonnull LivingEntity entity, @Nonnull BlockState state, @Nonnull IWorldReader world, @Nonnull Vector3d pos, @Nullable Direction side) {
        BlockState newState;
        IFacadeAccessor accessor;
        if (crackers.size() > 0 && state.func_185904_a() != Material.field_151579_a && (accessor = crackers.get(state.func_177230_c())) != null && (newState = accessor.getBlockState(entity, state, (IBlockReader)world, pos, side)) != null) {
            return newState;
        }
        return state;
    }

    static {
        ArrayList<IFacadeAccessor> accessors = new ArrayList<IFacadeAccessor>();
        FacadeHelper.addAccessor(accessors, new ChiselFacadeAccessor());
        if (accessors.size() > 0) {
            block0: for (Block b : ForgeRegistries.BLOCKS) {
                for (IFacadeAccessor accessor : accessors) {
                    if (!accessor.instanceOf(b)) continue;
                    crackers.put(b, accessor);
                    continue block0;
                }
            }
        }
    }
}

