/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.capabilities;

import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.api.IAntiqueTextProvider;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.capabilities.SupplementariesCapabilities;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class CapabilitiesHandler {
    public static void register() {
        CapabilityManager.INSTANCE.register(ICatchableMob.class, (Capability.IStorage)new DummyStorage(), DummyCatchableMobCap::new);
        CapabilityManager.INSTANCE.register(IAntiqueTextProvider.class, (Capability.IStorage)new AntiqueTextStorage(), () -> new SimpleAntiqueInkCap());
    }

    public static class DummyCatchableMobCap
    implements ICatchableMob {
        @Override
        public boolean canBeCaughtWithJar() {
            return false;
        }

        @Override
        public boolean canBeCaughtWithTintedJar() {
            return false;
        }

        @Override
        public boolean canBeCaughtWithCage() {
            return false;
        }

        @Override
        public Entity getEntity() {
            return null;
        }
    }

    private static class DummyStorage
    implements Capability.IStorage<ICatchableMob> {
        private DummyStorage() {
        }

        @Nullable
        public INBT writeNBT(Capability<ICatchableMob> capability, ICatchableMob instance, Direction side) {
            return null;
        }

        public void readNBT(Capability<ICatchableMob> capability, ICatchableMob instance, Direction side, INBT nbt) {
        }
    }

    private static class SimpleAntiqueInkCap
    implements IAntiqueTextProvider {
        private boolean ink;

        private SimpleAntiqueInkCap() {
        }

        @Override
        public boolean hasAntiqueInk() {
            return this.ink;
        }

        @Override
        public void setAntiqueInk(boolean hasInk) {
            this.ink = hasInk;
        }
    }

    public static class AntiqueInkProvider
    extends SimpleAntiqueInkCap
    implements ICapabilityProvider {
        public AntiqueInkProvider() {
            boolean a = true;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
            return capability == SupplementariesCapabilities.ANTIQUE_TEXT_CAP ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
        }
    }

    private static class AntiqueTextStorage
    implements Capability.IStorage<IAntiqueTextProvider> {
        private AntiqueTextStorage() {
        }

        @Nullable
        public INBT writeNBT(Capability<IAntiqueTextProvider> capability, IAntiqueTextProvider instance, Direction side) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("AntiqueInk", instance.hasAntiqueInk());
            return tag;
        }

        public void readNBT(Capability<IAntiqueTextProvider> capability, IAntiqueTextProvider instance, Direction side, INBT nbt) {
            instance.setAntiqueInk(nbt instanceof CompoundNBT && ((CompoundNBT)nbt).func_74767_n("AntiqueInk"));
        }
    }
}

