/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.ErrorFactory;
import cc.tweaked.internal.cobalt.LuaDouble;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaTable;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.function.LibFunction;
import cc.tweaked.internal.cobalt.function.OneArgFunction;
import cc.tweaked.internal.cobalt.function.TwoArgFunction;
import cc.tweaked.internal.cobalt.function.VarArgFunction;
import cc.tweaked.internal.cobalt.lib.LuaLibrary;
import java.util.Random;

public class MathLib
implements LuaLibrary {
    @Override
    public LuaValue add(LuaState state, LuaTable env) {
        LuaTable t = new LuaTable(0, 30);
        t.rawset("pi", (LuaValue)ValueFactory.valueOf(Math.PI));
        t.rawset("huge", (LuaValue)LuaDouble.POSINF);
        LibFunction.bind(t, () -> new MathLib1(), new String[]{"abs", "ceil", "cos", "deg", "exp", "floor", "rad", "sin", "sqrt", "tan", "acos", "asin", "atan", "cosh", "exp", "log10", "sinh", "tanh"});
        LibFunction.bind(t, () -> new MathLib2(), new String[]{"fmod", "ldexp", "pow", "atan2", "log"});
        LibFunction.bind(t, () -> new MathLibV(), new String[]{"frexp", "max", "min", "modf", "randomseed", "random"});
        t.rawset("mod", t.rawget("fmod"));
        env.rawset("math", (LuaValue)t);
        state.loadedPackages.rawset("math", (LuaValue)t);
        return t;
    }

    private static final class MathLibV
    extends VarArgFunction {
        private MathLibV() {
        }

        @Override
        public Varargs invoke(LuaState state, Varargs args) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    double x = args.arg(1).checkDouble();
                    if (x == 0.0) {
                        return ValueFactory.varargsOf((LuaValue)Constants.ZERO, (Varargs)Constants.ZERO);
                    }
                    long bits = Double.doubleToLongBits(x);
                    double m = (double)((bits & 0xFFFFFFFFFFFFFL) + 0x10000000000000L) * (bits >= 0L ? (double)1.110223E-16f : (double)-1.110223E-16f);
                    double e = ((int)(bits >> 52) & 0x7FF) - 1022;
                    return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(m), (Varargs)ValueFactory.valueOf(e));
                }
                case 1: {
                    double m = args.arg(1).checkDouble();
                    int n = args.count();
                    for (int i = 2; i <= n; ++i) {
                        m = Math.max(m, args.arg(i).checkDouble());
                    }
                    return ValueFactory.valueOf(m);
                }
                case 2: {
                    double m = args.arg(1).checkDouble();
                    int n = args.count();
                    for (int i = 2; i <= n; ++i) {
                        m = Math.min(m, args.arg(i).checkDouble());
                    }
                    return ValueFactory.valueOf(m);
                }
                case 3: {
                    double x = args.arg(1).checkDouble();
                    double intPart = x > 0.0 ? Math.floor(x) : Math.ceil(x);
                    double fracPart = x - intPart;
                    return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(intPart), (Varargs)ValueFactory.valueOf(fracPart));
                }
                case 4: {
                    long seed = args.arg(1).checkLong();
                    state.random = new Random(seed);
                    return Constants.NONE;
                }
                case 5: {
                    if (state.random == null) {
                        state.random = new Random();
                    }
                    switch (args.count()) {
                        case 0: {
                            return ValueFactory.valueOf(state.random.nextDouble());
                        }
                        case 1: {
                            int m = args.arg(1).checkInteger();
                            if (m < 1) {
                                throw ErrorFactory.argError(1, "interval is empty");
                            }
                            return ValueFactory.valueOf(1 + state.random.nextInt(m));
                        }
                    }
                    int m = args.arg(1).checkInteger();
                    int n = args.arg(2).checkInteger();
                    if (n < m) {
                        throw ErrorFactory.argError(2, "interval is empty");
                    }
                    return ValueFactory.valueOf(m + state.random.nextInt(n + 1 - m));
                }
            }
            return Constants.NONE;
        }
    }

    private static final class MathLib2
    extends TwoArgFunction {
        private MathLib2() {
        }

        @Override
        public LuaValue call(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    double x = arg1.checkDouble();
                    double y = arg2.checkDouble();
                    double q = x / y;
                    double f = x - y * (q >= 0.0 ? Math.floor(q) : Math.ceil(q));
                    return ValueFactory.valueOf(f);
                }
                case 1: {
                    double x = arg1.checkDouble();
                    double y = arg2.checkDouble() + 1023.5;
                    long e = (long)(0 != (1 & (int)y) ? Math.floor(y) : Math.ceil(y - 1.0));
                    return ValueFactory.valueOf(x * Double.longBitsToDouble(e << 52));
                }
                case 2: {
                    return ValueFactory.valueOf(Math.pow(arg1.checkDouble(), arg2.checkDouble()));
                }
                case 3: {
                    return ValueFactory.valueOf(Math.atan2(arg1.checkDouble(), arg2.checkDouble()));
                }
                case 4: {
                    if (arg2.isNil()) {
                        return ValueFactory.valueOf(Math.log(arg1.checkDouble()));
                    }
                    return ValueFactory.valueOf(Math.log(arg1.checkDouble()) / Math.log(arg2.checkDouble()));
                }
            }
            return Constants.NIL;
        }
    }

    private static final class MathLib1
    extends OneArgFunction {
        private MathLib1() {
        }

        @Override
        public LuaValue call(LuaState state, LuaValue arg) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    return ValueFactory.valueOf(Math.abs(arg.checkDouble()));
                }
                case 1: {
                    return ValueFactory.valueOf(Math.ceil(arg.checkDouble()));
                }
                case 2: {
                    return ValueFactory.valueOf(Math.cos(arg.checkDouble()));
                }
                case 3: {
                    return ValueFactory.valueOf(Math.toDegrees(arg.checkDouble()));
                }
                case 4: {
                    return ValueFactory.valueOf(Math.exp(arg.checkDouble()));
                }
                case 5: {
                    return ValueFactory.valueOf(Math.floor(arg.checkDouble()));
                }
                case 6: {
                    return ValueFactory.valueOf(Math.toRadians(arg.checkDouble()));
                }
                case 7: {
                    return ValueFactory.valueOf(Math.sin(arg.checkDouble()));
                }
                case 8: {
                    return ValueFactory.valueOf(Math.sqrt(arg.checkDouble()));
                }
                case 9: {
                    return ValueFactory.valueOf(Math.tan(arg.checkDouble()));
                }
                case 10: {
                    return ValueFactory.valueOf(Math.acos(arg.checkDouble()));
                }
                case 11: {
                    return ValueFactory.valueOf(Math.asin(arg.checkDouble()));
                }
                case 12: {
                    return ValueFactory.valueOf(Math.atan(arg.checkDouble()));
                }
                case 13: {
                    return ValueFactory.valueOf(Math.cosh(arg.checkDouble()));
                }
                case 14: {
                    return ValueFactory.valueOf(Math.exp(arg.checkDouble()));
                }
                case 15: {
                    return ValueFactory.valueOf(Math.log10(arg.checkDouble()));
                }
                case 16: {
                    return ValueFactory.valueOf(Math.sinh(arg.checkDouble()));
                }
                case 17: {
                    return ValueFactory.valueOf(Math.tanh(arg.checkDouble()));
                }
            }
            return Constants.NIL;
        }
    }
}

