/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft;

import com.google.auto.service.AutoService;
import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.DetailRegistry;
import dan200.computercraft.api.detail.IDetailProvider;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.api.media.IMediaProvider;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.core.apis.ApiFactories;
import dan200.computercraft.core.asm.GenericMethod;
import dan200.computercraft.core.filesystem.FileMount;
import dan200.computercraft.core.filesystem.ResourceMount;
import dan200.computercraft.impl.ComputerCraftAPIService;
import dan200.computercraft.impl.detail.DetailRegistryImpl;
import dan200.computercraft.shared.BundledRedstone;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.MediaProviders;
import dan200.computercraft.shared.Peripherals;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheralProvider;
import dan200.computercraft.shared.peripheral.generic.data.BlockData;
import dan200.computercraft.shared.peripheral.generic.data.FluidData;
import dan200.computercraft.shared.peripheral.generic.data.ItemData;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessNetwork;
import dan200.computercraft.shared.wired.WiredNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@AutoService(value={ComputerCraftAPIService.class})
public final class ComputerCraftAPIImpl
implements ComputerCraftAPIService {
    private final DetailRegistry<ItemStack> itemStackDetails = new DetailRegistryImpl<ItemStack>(ItemData::fillBasic);
    private final DetailRegistry<BlockReference> blockDetails = new DetailRegistryImpl<BlockReference>(BlockData::fillBasic);
    private final DetailRegistry<FluidStack> fluidStackDetails = new DetailRegistryImpl<FluidStack>(FluidData::fillBasic);
    private String version;

    public static InputStream getResourceFile(MinecraftServer server, String domain, String subPath) {
        IResourceManager manager = server.getDataPackRegistries().func_240970_h_();
        try {
            return manager.func_199002_a(new ResourceLocation(domain, subPath)).func_199027_b();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Override
    @Nonnull
    public String getInstalledVersion() {
        if (this.version != null) {
            return this.version;
        }
        this.version = ModList.get().getModContainerById("computercraft").map(x -> x.getModInfo().getVersion().toString()).orElse("unknown");
        return this.version;
    }

    @Override
    public int createUniqueNumberedSaveDir(@Nonnull World world, @Nonnull String parentSubPath) {
        return ServerContext.get(world.func_73046_m()).getNextId(parentSubPath);
    }

    @Override
    public IWritableMount createSaveDirMount(@Nonnull World world, @Nonnull String subPath, long capacity) {
        try {
            return new FileMount(new File(ServerContext.get(world.func_73046_m()).storageDir().toFile(), subPath), capacity);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public IMount createResourceMount(@Nonnull String domain, @Nonnull String subPath) {
        IResourceManager manager = ServerLifecycleHooks.getCurrentServer().getDataPackRegistries().func_240970_h_();
        ResourceMount mount = ResourceMount.get(domain, subPath, manager);
        return mount.exists("") ? mount : null;
    }

    @Override
    public void registerPeripheralProvider(@Nonnull IPeripheralProvider provider) {
        Peripherals.register(provider);
    }

    @Override
    public void registerGenericSource(@Nonnull GenericSource source) {
        GenericMethod.register(source);
    }

    @Override
    public void registerGenericCapability(@Nonnull Capability<?> capability) {
        GenericPeripheralProvider.addCapability(capability);
    }

    @Override
    public void registerTurtleUpgrade(@Nonnull ITurtleUpgrade upgrade) {
        TurtleUpgrades.register(upgrade);
    }

    @Override
    public void registerBundledRedstoneProvider(@Nonnull IBundledRedstoneProvider provider) {
        BundledRedstone.register(provider);
    }

    @Override
    public int getBundledRedstoneOutput(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return BundledRedstone.getDefaultOutput(world, pos, side);
    }

    @Override
    public void registerMediaProvider(@Nonnull IMediaProvider provider) {
        MediaProviders.register(provider);
    }

    @Override
    public void registerPocketUpgrade(@Nonnull IPocketUpgrade upgrade) {
        PocketUpgrades.register(upgrade);
    }

    @Override
    @Nonnull
    public IPacketNetwork getWirelessNetwork() {
        return WirelessNetwork.getUniversal();
    }

    @Override
    public void registerAPIFactory(@Nonnull ILuaAPIFactory factory) {
        ApiFactories.register(factory);
    }

    @Override
    @Deprecated
    public <T> void registerDetailProvider(@Nonnull Class<T> type, @Nonnull IDetailProvider<T> provider) {
        if (type == ItemStack.class) {
            this.itemStackDetails.addProvider(provider);
        } else if (type == BlockReference.class) {
            this.blockDetails.addProvider(provider);
        } else if (type == FluidStack.class) {
            this.itemStackDetails.addProvider(provider);
        } else {
            throw new IllegalArgumentException("Unknown detail provider " + type);
        }
    }

    @Override
    @Nonnull
    public IWiredNode createWiredNodeForElement(@Nonnull IWiredElement element) {
        return new WiredNode(element);
    }

    @Override
    @Nonnull
    public LazyOptional<IWiredElement> getWiredElementAt(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        TileEntity tile = world.func_175625_s(pos);
        return tile == null ? LazyOptional.empty() : tile.getCapability(Capabilities.CAPABILITY_WIRED_ELEMENT, side);
    }

    @Override
    public DetailRegistry<ItemStack> getItemStackDetailRegistry() {
        return this.itemStackDetails;
    }

    @Override
    public DetailRegistry<BlockReference> getBlockInWorldDetailRegistry() {
        return this.blockDetails;
    }

    @Override
    public DetailRegistry<FluidStack> getFluidStackDetailRegistry() {
        return this.fluidStackDetails;
    }
}

