/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.inventory;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.computer.menu.ServerInputState;
import dan200.computercraft.shared.network.client.TerminalState;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;

public abstract class ContainerComputerBase
extends Container
implements ComputerMenu {
    private final Predicate<PlayerEntity> canUse;
    private final ComputerFamily family;
    private final IIntArray data;
    @Nullable
    private final ServerComputer computer;
    @Nullable
    private final ServerInputState<ContainerComputerBase> input;
    @Nullable
    private final Terminal terminal;
    private final ItemStack displayStack;

    public ContainerComputerBase(ContainerType<? extends ContainerComputerBase> type, int id, Predicate<PlayerEntity> canUse, ComputerFamily family, @Nullable ServerComputer computer, @Nullable ComputerContainerData containerData) {
        super(type, id);
        this.canUse = canUse;
        this.family = family;
        this.data = computer == null ? new IntArray(1) : () -> computer.isOn() ? 1 : 0;
        this.func_216961_a(this.data);
        this.computer = computer;
        this.input = computer == null ? null : new ServerInputState<ContainerComputerBase>(this);
        this.terminal = containerData == null ? null : containerData.terminal().create();
        this.displayStack = containerData == null ? null : containerData.displayStack();
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return this.canUse.test(player);
    }

    @Nonnull
    public ComputerFamily getFamily() {
        return this.family;
    }

    public boolean isOn() {
        return this.data.func_221476_a(0) != 0;
    }

    @Override
    public ServerComputer getComputer() {
        if (this.computer == null) {
            throw new UnsupportedOperationException("Cannot access server computer on the client");
        }
        return this.computer;
    }

    @Override
    public ServerInputHandler getInput() {
        if (this.input == null) {
            throw new UnsupportedOperationException("Cannot access server computer on the client");
        }
        return this.input;
    }

    @Override
    public void updateTerminal(TerminalState state) {
        if (this.terminal == null) {
            throw new UnsupportedOperationException("Cannot update terminal on the server");
        }
        state.apply(this.terminal);
    }

    public Terminal getTerminal() {
        if (this.terminal == null) {
            throw new IllegalStateException("Cannot update terminal on the server");
        }
        return this.terminal;
    }

    public void func_75134_a(@Nonnull PlayerEntity player) {
        super.func_75134_a(player);
        if (this.input != null) {
            this.input.close();
        }
    }

    @Nonnull
    public ItemStack getDisplayStack() {
        return this.displayStack;
    }
}

