/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.logger.ILogger;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.shared.TurtleUpgrades;
import net.minecraftforge.fml.LogicalSide;

public class RemoveTurtleUpgradeByName
implements IUndoableAction {
    private final String id;
    private ITurtleUpgrade upgrade;

    public RemoveTurtleUpgradeByName(String id) {
        this.id = id;
    }

    public void apply() {
        this.upgrade = TurtleUpgrades.get(this.id);
        ITurtleUpgrade upgrade = this.upgrade;
        if (upgrade != null) {
            TurtleUpgrades.disable(upgrade);
        }
    }

    public String describe() {
        return String.format("Remove turtle upgrade '%s'", this.id);
    }

    public void undo() {
        if (this.upgrade != null) {
            TurtleUpgrades.enable(this.upgrade);
        }
    }

    public String describeUndo() {
        return String.format("Adding back turtle upgrade '%s'", this.id);
    }

    public boolean validate(ILogger logger) {
        if (TurtleUpgrades.get(this.id) == null) {
            logger.error(String.format("Unknown turtle upgrade '%s'.", this.id));
            return false;
        }
        return true;
    }

    public boolean shouldApplyOn(LogicalSide side) {
        return true;
    }
}

