/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.container;

import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.client.TerminalState;
import dan200.computercraft.shared.network.container.ContainerData;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ComputerContainerData
implements ContainerData {
    private final ComputerFamily family;
    private final TerminalState terminal;
    private final ItemStack displayStack;

    public ComputerContainerData(ServerComputer computer, @Nonnull ItemStack displayStack) {
        this.family = computer.getFamily();
        this.terminal = computer.getTerminalState();
        this.displayStack = displayStack;
    }

    public ComputerContainerData(PacketBuffer buf) {
        this.family = (ComputerFamily)buf.func_179257_a(ComputerFamily.class);
        this.terminal = new TerminalState(buf);
        this.displayStack = buf.func_150791_c();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.family);
        this.terminal.write(buf);
        buf.writeItemStack(this.displayStack, true);
    }

    public ComputerFamily family() {
        return this.family;
    }

    public TerminalState terminal() {
        return this.terminal;
    }

    @Nonnull
    public ItemStack displayStack() {
        return this.displayStack;
    }
}

