/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.computer.upload.FileSlice;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import io.netty.handler.codec.DecoderException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class UploadFileMessage
extends ComputerServerMessage {
    public static final int MAX_SIZE = 524288;
    static final int MAX_PACKET_SIZE = 30720;
    public static final int MAX_FILES = 32;
    public static final int MAX_FILE_NAME = 128;
    @VisibleForTesting
    static final int FLAG_FIRST = 1;
    @VisibleForTesting
    static final int FLAG_LAST = 2;
    private final UUID uuid;
    @VisibleForTesting
    final int flag;
    @VisibleForTesting
    final List<FileUpload> files;
    @VisibleForTesting
    final List<FileSlice> slices;

    UploadFileMessage(Container menu, UUID uuid, int flag, List<FileUpload> files, List<FileSlice> slices) {
        super(menu);
        this.uuid = uuid;
        this.flag = flag;
        this.files = files;
        this.slices = slices;
    }

    public UploadFileMessage(@Nonnull PacketBuffer buf) {
        super(buf);
        int i;
        this.uuid = buf.func_179253_g();
        byte by = buf.readByte();
        this.flag = by;
        byte flag = by;
        int totalSize = 0;
        if ((flag & 1) != 0) {
            int nFiles = buf.func_150792_a();
            if (nFiles > 32) {
                throw new DecoderException("Too many files");
            }
            this.files = new ArrayList<FileUpload>(nFiles);
            ArrayList<FileUpload> files = this.files;
            for (i = 0; i < nFiles; ++i) {
                String name = buf.func_150789_c(128);
                int size = buf.func_150792_a();
                if (size > 524288 || (totalSize += size) > 524288) {
                    throw new DecoderException("Files are too large");
                }
                byte[] digest = new byte[32];
                buf.readBytes(digest);
                files.add(new FileUpload(name, ByteBuffer.allocateDirect(size), digest));
            }
        } else {
            this.files = null;
        }
        int nSlices = buf.func_150792_a();
        this.slices = new ArrayList<FileSlice>(nSlices);
        ArrayList<FileSlice> slices = this.slices;
        for (i = 0; i < nSlices; ++i) {
            short fileId = buf.readUnsignedByte();
            int offset = buf.func_150792_a();
            int size = buf.readUnsignedShort();
            if (size > 30720) {
                throw new DecoderException("File is too large");
            }
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            buf.readBytes(buffer);
            buffer.flip();
            slices.add(new FileSlice(fileId, offset, buffer));
        }
    }

    @Override
    public void toBytes(@Nonnull PacketBuffer buf) {
        super.toBytes(buf);
        buf.func_179252_a(this.uuid);
        buf.writeByte(this.flag);
        if ((this.flag & 1) != 0) {
            buf.func_150787_b(this.files.size());
            for (FileUpload file : this.files) {
                buf.func_211400_a(file.getName(), 128);
                buf.func_150787_b(file.getLength());
                buf.writeBytes(file.getChecksum());
            }
        }
        buf.func_150787_b(this.slices.size());
        for (FileSlice slice : this.slices) {
            buf.writeByte(slice.getFileId());
            buf.func_150787_b(slice.getOffset());
            ByteBuffer bytes = slice.getBytes().duplicate();
            buf.writeShort(bytes.remaining());
            buf.writeBytes(bytes);
        }
    }

    public static void send(Container container, List<FileUpload> files, Consumer<UploadFileMessage> send) {
        UUID uuid = UUID.randomUUID();
        int remaining = 30720;
        for (FileUpload file : files) {
            remaining -= file.getName().length() * 4 + 32;
        }
        boolean first = true;
        ArrayList<FileSlice> slices = new ArrayList<FileSlice>(files.size());
        for (int fileId = 0; fileId < files.size(); ++fileId) {
            FileUpload file = files.get(fileId);
            ByteBuffer contents = file.getBytes();
            int capacity = contents.limit();
            int currentOffset = 0;
            while (currentOffset < capacity) {
                if (remaining <= 0) {
                    send.accept(first ? new UploadFileMessage(container, uuid, 1, files, new ArrayList<FileSlice>(slices)) : new UploadFileMessage(container, uuid, 0, null, new ArrayList<FileSlice>(slices)));
                    slices.clear();
                    remaining = 30720;
                    first = false;
                }
                int canWrite = Math.min(remaining, capacity - currentOffset);
                contents.position(currentOffset).limit(currentOffset + canWrite);
                slices.add(new FileSlice(fileId, currentOffset, contents.slice()));
                currentOffset += canWrite;
                remaining -= canWrite;
            }
            contents.position(0).limit(capacity);
        }
        send.accept(first ? new UploadFileMessage(container, uuid, 3, files, new ArrayList<FileSlice>(slices)) : new UploadFileMessage(container, uuid, 2, null, new ArrayList<FileSlice>(slices)));
    }

    @Override
    protected void handle(NetworkEvent.Context context, @Nonnull ComputerMenu container) {
        ServerPlayerEntity player = context.getSender();
        if (player != null) {
            ServerInputHandler input = container.getInput();
            if ((this.flag & 1) != 0) {
                input.startUpload(this.uuid, this.files);
            }
            input.continueUpload(this.uuid, this.slices);
            if ((this.flag & 2) != 0) {
                input.finishUpload(player, this.uuid);
            }
        }
    }
}

