/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class WirelessModemPeripheral
extends ModemPeripheral {
    private final boolean advanced;

    public WirelessModemPeripheral(ModemState state, boolean advanced) {
        super(state);
        this.advanced = advanced;
    }

    @Override
    public boolean isInterdimensional() {
        return this.advanced;
    }

    @Override
    public double getRange() {
        if (this.advanced) {
            return 2.147483647E9;
        }
        World world = this.getWorld();
        if (world != null) {
            Vector3d position = this.getPosition();
            double minRange = ComputerCraft.modemRange;
            double maxRange = ComputerCraft.modemHighAltitudeRange;
            if (world.func_72896_J() && world.func_72911_I()) {
                minRange = ComputerCraft.modemRangeDuringStorm;
                maxRange = ComputerCraft.modemHighAltitudeRangeDuringStorm;
            }
            if (position.field_72448_b > 96.0 && maxRange > minRange) {
                return minRange + (position.field_72448_b - 96.0) * ((maxRange - minRange) / ((double)(world.func_217301_I() - 1) - 96.0));
            }
            return minRange;
        }
        return 0.0;
    }

    @Override
    protected IPacketNetwork getNetwork() {
        return ComputerCraftAPI.getWirelessNetwork();
    }
}

