/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.google.common.base.Objects;
import com.mojang.authlib.GameProfile;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleCommandQueueEntry;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.HolidayUtil;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TurtleBrain
implements ITurtleAccess {
    public static final String NBT_RIGHT_UPGRADE = "RightUpgrade";
    public static final String NBT_RIGHT_UPGRADE_DATA = "RightUpgradeNbt";
    public static final String NBT_LEFT_UPGRADE = "LeftUpgrade";
    public static final String NBT_LEFT_UPGRADE_DATA = "LeftUpgradeNbt";
    public static final String NBT_FUEL = "Fuel";
    public static final String NBT_OVERLAY = "Overlay";
    private static final String NBT_SLOT = "Slot";
    private static final int ANIM_DURATION = 8;
    public static final Predicate<Entity> PUSHABLE_ENTITY = entity -> !entity.func_175149_v() && entity.func_184192_z() != PushReaction.IGNORE;
    private TileTurtle owner;
    private ComputerProxy proxy;
    private GameProfile owningPlayer;
    private final IInventory inventory = () -> this.owner;
    private final IItemHandlerModifiable inventoryWrapper = new InvWrapper(this.inventory);
    private final Queue<TurtleCommandQueueEntry> commandQueue = new ArrayDeque<TurtleCommandQueueEntry>();
    private int commandsIssued = 0;
    private final Map<TurtleSide, ITurtleUpgrade> upgrades = new EnumMap<TurtleSide, ITurtleUpgrade>(TurtleSide.class);
    private final Map<TurtleSide, IPeripheral> peripherals = new EnumMap<TurtleSide, IPeripheral>(TurtleSide.class);
    private final Map<TurtleSide, CompoundNBT> upgradeNBTData = new EnumMap<TurtleSide, CompoundNBT>(TurtleSide.class);
    private int selectedSlot = 0;
    private int fuelLevel = 0;
    private int colourHex = -1;
    private ResourceLocation overlay = null;
    private TurtleAnimation animation = TurtleAnimation.NONE;
    private int animationProgress = 0;
    private int lastAnimationProgress = 0;
    TurtlePlayer cachedPlayer;

    public TurtleBrain(TileTurtle turtle) {
        this.owner = turtle;
    }

    public void setOwner(TileTurtle owner) {
        this.owner = owner;
    }

    public TileTurtle getOwner() {
        return this.owner;
    }

    public ComputerProxy getProxy() {
        if (this.proxy == null) {
            this.proxy = new ComputerProxy(() -> this.owner);
        }
        return this.proxy;
    }

    public ComputerFamily getFamily() {
        return this.owner.getFamily();
    }

    public void setupComputer(ServerComputer computer) {
        this.updatePeripherals(computer);
    }

    public void update() {
        World world = this.getWorld();
        if (!world.field_72995_K) {
            this.updateCommands();
            if (this.owner.func_145837_r()) {
                return;
            }
        }
        this.updateAnimation();
        if (!this.upgrades.isEmpty()) {
            for (Map.Entry<TurtleSide, ITurtleUpgrade> entry : this.upgrades.entrySet()) {
                entry.getValue().update(this, entry.getKey());
            }
        }
    }

    private void readCommon(CompoundNBT nbt) {
        this.colourHex = nbt.func_74764_b("Color") ? nbt.func_74762_e("Color") : -1;
        this.fuelLevel = nbt.func_74764_b(NBT_FUEL) ? nbt.func_74762_e(NBT_FUEL) : 0;
        this.overlay = nbt.func_74764_b(NBT_OVERLAY) ? new ResourceLocation(nbt.func_74779_i(NBT_OVERLAY)) : null;
        this.setUpgradeDirect(TurtleSide.LEFT, nbt.func_74764_b(NBT_LEFT_UPGRADE) ? TurtleUpgrades.get(nbt.func_74779_i(NBT_LEFT_UPGRADE)) : null);
        this.setUpgradeDirect(TurtleSide.RIGHT, nbt.func_74764_b(NBT_RIGHT_UPGRADE) ? TurtleUpgrades.get(nbt.func_74779_i(NBT_RIGHT_UPGRADE)) : null);
        this.upgradeNBTData.clear();
        if (nbt.func_74764_b(NBT_LEFT_UPGRADE_DATA)) {
            this.upgradeNBTData.put(TurtleSide.LEFT, nbt.func_74775_l(NBT_LEFT_UPGRADE_DATA).func_74737_b());
        }
        if (nbt.func_74764_b(NBT_RIGHT_UPGRADE_DATA)) {
            this.upgradeNBTData.put(TurtleSide.RIGHT, nbt.func_74775_l(NBT_RIGHT_UPGRADE_DATA).func_74737_b());
        }
    }

    private void writeCommon(CompoundNBT nbt) {
        String rightUpgradeId;
        String leftUpgradeId;
        nbt.func_74768_a(NBT_FUEL, this.fuelLevel);
        if (this.colourHex != -1) {
            nbt.func_74768_a("Color", this.colourHex);
        }
        if (this.overlay != null) {
            nbt.func_74778_a(NBT_OVERLAY, this.overlay.toString());
        }
        if ((leftUpgradeId = TurtleBrain.getUpgradeId(this.getUpgrade(TurtleSide.LEFT))) != null) {
            nbt.func_74778_a(NBT_LEFT_UPGRADE, leftUpgradeId);
        }
        if ((rightUpgradeId = TurtleBrain.getUpgradeId(this.getUpgrade(TurtleSide.RIGHT))) != null) {
            nbt.func_74778_a(NBT_RIGHT_UPGRADE, rightUpgradeId);
        }
        if (this.upgradeNBTData.containsKey((Object)TurtleSide.LEFT)) {
            nbt.func_218657_a(NBT_LEFT_UPGRADE_DATA, (INBT)this.getUpgradeNBTData(TurtleSide.LEFT).func_74737_b());
        }
        if (this.upgradeNBTData.containsKey((Object)TurtleSide.RIGHT)) {
            nbt.func_218657_a(NBT_RIGHT_UPGRADE_DATA, (INBT)this.getUpgradeNBTData(TurtleSide.RIGHT).func_74737_b());
        }
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.readCommon(nbt);
        this.selectedSlot = nbt.func_74762_e(NBT_SLOT);
        if (nbt.func_150297_b("Owner", 10)) {
            CompoundNBT owner = nbt.func_74775_l("Owner");
            this.owningPlayer = new GameProfile(new UUID(owner.func_74763_f("UpperId"), owner.func_74763_f("LowerId")), owner.func_74779_i("Name"));
        } else {
            this.owningPlayer = null;
        }
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        this.writeCommon(nbt);
        nbt.func_74768_a(NBT_SLOT, this.selectedSlot);
        if (this.owningPlayer != null) {
            CompoundNBT owner = new CompoundNBT();
            nbt.func_218657_a("Owner", (INBT)owner);
            owner.func_74772_a("UpperId", this.owningPlayer.getId().getMostSignificantBits());
            owner.func_74772_a("LowerId", this.owningPlayer.getId().getLeastSignificantBits());
            owner.func_74778_a("Name", this.owningPlayer.getName());
        }
        return nbt;
    }

    private static String getUpgradeId(ITurtleUpgrade upgrade) {
        return upgrade != null ? upgrade.getUpgradeID().toString() : null;
    }

    public void readDescription(CompoundNBT nbt) {
        this.readCommon(nbt);
        TurtleAnimation anim = TurtleAnimation.values()[nbt.func_74762_e("Animation")];
        if (anim != this.animation && anim != TurtleAnimation.WAIT && anim != TurtleAnimation.SHORT_WAIT && anim != TurtleAnimation.NONE) {
            this.animation = anim;
            this.animationProgress = 0;
            this.lastAnimationProgress = 0;
        }
    }

    public void writeDescription(CompoundNBT nbt) {
        this.writeCommon(nbt);
        nbt.func_74768_a("Animation", this.animation.ordinal());
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.owner.func_145831_w();
    }

    @Override
    @Nonnull
    public BlockPos getPosition() {
        return this.owner.func_174877_v();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean teleportTo(@Nonnull World world, @Nonnull BlockPos pos) {
        if (world.field_72995_K || this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException("Cannot teleport on the client");
        }
        World oldWorld = this.getWorld();
        TileTurtle oldOwner = this.owner;
        BlockPos oldPos = this.owner.func_174877_v();
        BlockState oldBlock = this.owner.func_195044_w();
        if (oldWorld == world && oldPos.equals((Object)pos)) {
            return true;
        }
        if (!world.isAreaLoaded(pos, 0)) {
            return false;
        }
        if (!world.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        FluidState existingFluid = world.func_180495_p(pos).func_204520_s();
        BlockState newState = (BlockState)oldBlock.func_206870_a((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(existingFluid.func_206884_a((ITag)FluidTags.field_206959_a) && existingFluid.func_206889_d()));
        oldOwner.notifyMoveStart();
        try {
            if (world.func_180501_a(pos, newState, 2)) {
                TileEntity newTile;
                Block block = world.func_180495_p(pos).func_177230_c();
                if (block == oldBlock.func_177230_c() && (newTile = world.func_175625_s(pos)) instanceof TileTurtle) {
                    TileTurtle newTurtle = (TileTurtle)newTile;
                    newTurtle.func_226984_a_(world, pos);
                    newTurtle.transferStateFrom(oldOwner);
                    ServerComputer computer = newTurtle.createServerComputer();
                    computer.setWorld((ServerWorld)world);
                    computer.setPosition(pos);
                    oldWorld.func_217377_a(oldPos, false);
                    newTurtle.updateOutput();
                    newTurtle.updateInputsImmediately();
                    boolean bl = true;
                    return bl;
                }
                world.func_217377_a(pos, false);
            }
        }
        finally {
            oldOwner.notifyMoveEnd();
        }
        return false;
    }

    @Override
    @Nonnull
    public Vector3d getVisualPosition(float f) {
        Vector3d offset = this.getRenderOffset(f);
        BlockPos pos = this.owner.func_174877_v();
        return new Vector3d((double)pos.func_177958_n() + 0.5 + offset.field_72450_a, (double)pos.func_177956_o() + 0.5 + offset.field_72448_b, (double)pos.func_177952_p() + 0.5 + offset.field_72449_c);
    }

    @Override
    public float getVisualYaw(float f) {
        float yaw = this.getDirection().func_185119_l();
        switch (this.animation) {
            case TURN_LEFT: {
                yaw += 90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw >= 360.0f)) break;
                yaw -= 360.0f;
                break;
            }
            case TURN_RIGHT: {
                yaw += -90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw < 0.0f)) break;
                yaw += 360.0f;
            }
        }
        return yaw;
    }

    @Override
    @Nonnull
    public Direction getDirection() {
        return this.owner.getDirection();
    }

    @Override
    public void setDirection(@Nonnull Direction dir) {
        this.owner.setDirection(dir);
    }

    @Override
    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public void setSelectedSlot(int slot) {
        if (this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException("Cannot set the slot on the client");
        }
        if (slot >= 0 && slot < this.owner.func_70302_i_()) {
            this.selectedSlot = slot;
            this.owner.onTileEntityChange();
        }
    }

    @Override
    @Nonnull
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public IItemHandlerModifiable getItemHandler() {
        return this.inventoryWrapper;
    }

    @Override
    public boolean isFuelNeeded() {
        return ComputerCraft.turtlesNeedFuel;
    }

    @Override
    public int getFuelLevel() {
        return Math.min(this.fuelLevel, this.getFuelLimit());
    }

    @Override
    public void setFuelLevel(int level) {
        this.fuelLevel = Math.min(level, this.getFuelLimit());
        this.owner.onTileEntityChange();
    }

    @Override
    public int getFuelLimit() {
        if (this.owner.getFamily() == ComputerFamily.ADVANCED) {
            return ComputerCraft.advancedTurtleFuelLimit;
        }
        return ComputerCraft.turtleFuelLimit;
    }

    @Override
    public boolean consumeFuel(int fuel) {
        if (this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException("Cannot consume fuel on the client");
        }
        if (!this.isFuelNeeded()) {
            return true;
        }
        int consumption = Math.max(fuel, 0);
        if (this.getFuelLevel() >= consumption) {
            this.setFuelLevel(this.getFuelLevel() - consumption);
            return true;
        }
        return false;
    }

    @Override
    public void addFuel(int fuel) {
        if (this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException("Cannot add fuel on the client");
        }
        int addition = Math.max(fuel, 0);
        this.setFuelLevel(this.getFuelLevel() + addition);
    }

    @Override
    @Nonnull
    public MethodResult executeCommand(@Nonnull ITurtleCommand command) {
        if (this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException("Cannot run commands on the client");
        }
        if (this.commandQueue.size() > 16) {
            return MethodResult.of(false, "Too many ongoing turtle commands");
        }
        this.commandQueue.offer(new TurtleCommandQueueEntry(++this.commandsIssued, command));
        int commandID = this.commandsIssued;
        return new CommandCallback((int)commandID).pull;
    }

    @Override
    public void playAnimation(@Nonnull TurtleAnimation animation) {
        if (this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException("Cannot play animations on the client");
        }
        this.animation = animation;
        if (this.animation == TurtleAnimation.SHORT_WAIT) {
            this.animationProgress = 4;
            this.lastAnimationProgress = 4;
        } else {
            this.animationProgress = 0;
            this.lastAnimationProgress = 0;
        }
        this.owner.updateBlock();
    }

    public ResourceLocation getOverlay() {
        return this.overlay;
    }

    public void setOverlay(ResourceLocation overlay) {
        if (!Objects.equal((Object)this.overlay, (Object)overlay)) {
            this.overlay = overlay;
            this.owner.updateBlock();
        }
    }

    public DyeColor getDyeColour() {
        if (this.colourHex == -1) {
            return null;
        }
        Colour colour = Colour.fromHex(this.colourHex);
        return colour == null ? null : DyeColor.func_196056_a((int)(15 - colour.ordinal()));
    }

    public void setDyeColour(DyeColor dyeColour) {
        int newColour = -1;
        if (dyeColour != null) {
            newColour = Colour.values()[15 - dyeColour.func_196059_a()].getHex();
        }
        if (this.colourHex != newColour) {
            this.colourHex = newColour;
            this.owner.updateBlock();
        }
    }

    @Override
    public void setColour(int colour) {
        if (colour >= 0 && colour <= 0xFFFFFF) {
            if (this.colourHex != colour) {
                this.colourHex = colour;
                this.owner.updateBlock();
            }
        } else if (this.colourHex != -1) {
            this.colourHex = -1;
            this.owner.updateBlock();
        }
    }

    @Override
    public int getColour() {
        return this.colourHex;
    }

    public void setOwningPlayer(GameProfile profile) {
        this.owningPlayer = profile;
    }

    @Override
    @Nullable
    public GameProfile getOwningPlayer() {
        return this.owningPlayer;
    }

    @Override
    public ITurtleUpgrade getUpgrade(@Nonnull TurtleSide side) {
        return this.upgrades.get((Object)side);
    }

    @Override
    public void setUpgrade(@Nonnull TurtleSide side, ITurtleUpgrade upgrade) {
        if (!this.setUpgradeDirect(side, upgrade) || this.owner.func_145831_w() == null) {
            return;
        }
        this.owner.updateBlock();
        this.owner.updateInputsImmediately();
    }

    private boolean setUpgradeDirect(@Nonnull TurtleSide side, ITurtleUpgrade upgrade) {
        if (this.upgrades.containsKey((Object)side)) {
            if (this.upgrades.get((Object)side) == upgrade) {
                return false;
            }
            this.upgrades.remove((Object)side);
        } else if (upgrade == null) {
            return false;
        }
        this.upgradeNBTData.remove((Object)side);
        if (upgrade != null) {
            this.upgrades.put(side, upgrade);
        }
        if (this.owner.func_145831_w() != null && !this.owner.func_145831_w().field_72995_K) {
            this.updatePeripherals(this.owner.createServerComputer());
        }
        return true;
    }

    @Override
    public IPeripheral getPeripheral(@Nonnull TurtleSide side) {
        return this.peripherals.get((Object)side);
    }

    @Override
    @Nonnull
    public CompoundNBT getUpgradeNBTData(TurtleSide side) {
        CompoundNBT nbt = this.upgradeNBTData.get((Object)side);
        if (nbt == null) {
            nbt = new CompoundNBT();
            this.upgradeNBTData.put(side, nbt);
        }
        return nbt;
    }

    @Override
    public void updateUpgradeNBTData(@Nonnull TurtleSide side) {
        this.owner.updateBlock();
    }

    public Vector3d getRenderOffset(float f) {
        switch (this.animation) {
            case MOVE_FORWARD: 
            case MOVE_BACK: 
            case MOVE_UP: 
            case MOVE_DOWN: {
                Direction dir;
                switch (this.animation) {
                    default: {
                        dir = this.getDirection();
                        break;
                    }
                    case MOVE_BACK: {
                        dir = this.getDirection().func_176734_d();
                        break;
                    }
                    case MOVE_UP: {
                        dir = Direction.UP;
                        break;
                    }
                    case MOVE_DOWN: {
                        dir = Direction.DOWN;
                    }
                }
                double distance = -1.0 + (double)this.getAnimationFraction(f);
                return new Vector3d(distance * (double)dir.func_82601_c(), distance * (double)dir.func_96559_d(), distance * (double)dir.func_82599_e());
            }
        }
        return Vector3d.field_186680_a;
    }

    public float getToolRenderAngle(TurtleSide side, float f) {
        return side == TurtleSide.LEFT && this.animation == TurtleAnimation.SWING_LEFT_TOOL || side == TurtleSide.RIGHT && this.animation == TurtleAnimation.SWING_RIGHT_TOOL ? 45.0f * (float)Math.sin((double)this.getAnimationFraction(f) * Math.PI) : 0.0f;
    }

    private static ComputerSide toDirection(TurtleSide side) {
        switch (side) {
            case LEFT: {
                return ComputerSide.LEFT;
            }
        }
        return ComputerSide.RIGHT;
    }

    private void updatePeripherals(ServerComputer serverComputer) {
        if (serverComputer == null) {
            return;
        }
        for (TurtleSide side : TurtleSide.values()) {
            IPeripheral existing;
            ITurtleUpgrade upgrade = this.getUpgrade(side);
            IPeripheral peripheral = null;
            if (upgrade != null && upgrade.getType().isPeripheral()) {
                peripheral = upgrade.createPeripheral(this, side);
            }
            if ((existing = this.peripherals.get((Object)side)) == peripheral || existing != null && peripheral != null && existing.equals(peripheral)) {
                peripheral = existing;
            } else {
                this.peripherals.put(side, peripheral);
            }
            serverComputer.setPeripheral(TurtleBrain.toDirection(side), peripheral);
        }
    }

    private void updateCommands() {
        if (this.animation != TurtleAnimation.NONE || this.commandQueue.isEmpty()) {
            return;
        }
        ServerComputer computer = this.owner.getServerComputer();
        if (computer != null && !computer.getComputer().getMainThreadMonitor().canWork()) {
            return;
        }
        TurtleCommandQueueEntry nextCommand = this.commandQueue.poll();
        if (nextCommand == null) {
            return;
        }
        long start = System.nanoTime();
        TurtleCommandResult result = nextCommand.command.execute(this);
        long end = System.nanoTime();
        if (computer == null) {
            return;
        }
        computer.getComputer().getMainThreadMonitor().trackWork(end - start, TimeUnit.NANOSECONDS);
        int callbackID = nextCommand.callbackID;
        if (callbackID < 0) {
            return;
        }
        if (result != null && result.isSuccess()) {
            Object[] results = result.getResults();
            if (results != null) {
                Object[] arguments = new Object[results.length + 2];
                arguments[0] = callbackID;
                arguments[1] = true;
                System.arraycopy(results, 0, arguments, 2, results.length);
                computer.queueEvent("turtle_response", arguments);
            } else {
                computer.queueEvent("turtle_response", new Object[]{callbackID, true});
            }
        } else {
            computer.queueEvent("turtle_response", new Object[]{callbackID, false, result != null ? result.getErrorMessage() : null});
        }
    }

    private void updateAnimation() {
        if (this.animation != TurtleAnimation.NONE) {
            Vector3d position;
            Holiday currentHoliday;
            World world = this.getWorld();
            if (ComputerCraft.turtlesCanPush && (this.animation == TurtleAnimation.MOVE_FORWARD || this.animation == TurtleAnimation.MOVE_BACK || this.animation == TurtleAnimation.MOVE_UP || this.animation == TurtleAnimation.MOVE_DOWN)) {
                Direction moveDir;
                BlockPos pos = this.getPosition();
                switch (this.animation) {
                    default: {
                        moveDir = this.getDirection();
                        break;
                    }
                    case MOVE_BACK: {
                        moveDir = this.getDirection().func_176734_d();
                        break;
                    }
                    case MOVE_UP: {
                        moveDir = Direction.UP;
                        break;
                    }
                    case MOVE_DOWN: {
                        moveDir = Direction.DOWN;
                    }
                }
                double minX = pos.func_177958_n();
                double minY = pos.func_177956_o();
                double minZ = pos.func_177952_p();
                double maxX = minX + 1.0;
                double maxY = minY + 1.0;
                double maxZ = minZ + 1.0;
                float pushFrac = 1.0f - (float)(this.animationProgress + 1) / 8.0f;
                float push = Math.max(pushFrac + 0.0125f, 0.0f);
                if (moveDir.func_82601_c() < 0) {
                    minX += (double)((float)moveDir.func_82601_c() * push);
                } else {
                    maxX -= (double)((float)moveDir.func_82601_c() * push);
                }
                if (moveDir.func_96559_d() < 0) {
                    minY += (double)((float)moveDir.func_96559_d() * push);
                } else {
                    maxY -= (double)((float)moveDir.func_96559_d() * push);
                }
                if (moveDir.func_82599_e() < 0) {
                    minZ += (double)((float)moveDir.func_82599_e() * push);
                } else {
                    maxZ -= (double)((float)moveDir.func_82599_e() * push);
                }
                AxisAlignedBB aabb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
                List list = world.func_175647_a(Entity.class, aabb, PUSHABLE_ENTITY);
                if (!list.isEmpty()) {
                    double pushStep = 0.125;
                    double pushStepX = (double)moveDir.func_82601_c() * pushStep;
                    double pushStepY = (double)moveDir.func_96559_d() * pushStep;
                    double pushStepZ = (double)moveDir.func_82599_e() * pushStep;
                    for (Entity entity : list) {
                        entity.func_213315_a(MoverType.PISTON, new Vector3d(pushStepX, pushStepY, pushStepZ));
                    }
                }
            }
            if (world.field_72995_K && this.animation == TurtleAnimation.MOVE_FORWARD && this.animationProgress == 4 && (currentHoliday = HolidayUtil.getCurrentHoliday()) == Holiday.VALENTINES && (position = this.getVisualPosition(1.0f)) != null) {
                double x = position.field_72450_a + world.field_73012_v.nextGaussian() * 0.1;
                double y = position.field_72448_b + 0.5 + world.field_73012_v.nextGaussian() * 0.1;
                double z = position.field_72449_c + world.field_73012_v.nextGaussian() * 0.1;
                world.func_195594_a((IParticleData)ParticleTypes.field_197633_z, x, y, z, world.field_73012_v.nextGaussian() * 0.02, world.field_73012_v.nextGaussian() * 0.02, world.field_73012_v.nextGaussian() * 0.02);
            }
            this.lastAnimationProgress = this.animationProgress++;
            if (this.animationProgress >= 8) {
                this.animation = TurtleAnimation.NONE;
                this.animationProgress = 0;
                this.lastAnimationProgress = 0;
            }
        }
    }

    private float getAnimationFraction(float f) {
        float next = (float)this.animationProgress / 8.0f;
        float previous = (float)this.lastAnimationProgress / 8.0f;
        return previous + (next - previous) * f;
    }

    private static final class CommandCallback
    implements ILuaCallback {
        final MethodResult pull = MethodResult.pullEvent("turtle_response", this);
        private final int command;

        CommandCallback(int command) {
            this.command = command;
        }

        @Override
        @Nonnull
        public MethodResult resume(Object[] response) {
            if (response.length < 3 || !(response[1] instanceof Number) || !(response[2] instanceof Boolean)) {
                return this.pull;
            }
            if (((Number)response[1]).intValue() != this.command) {
                return this.pull;
            }
            return MethodResult.of(Arrays.copyOfRange(response, 2, response.length));
        }
    }
}

