/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import dan200.computercraft.shared.peripheral.speaker.UpgradeSpeakerPeripheral;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TurtleSpeaker
extends AbstractTurtleUpgrade {
    private static final ResourceLocation leftModel = new ResourceLocation("computercraft", "block/turtle_speaker_left");
    private static final ResourceLocation rightModel = new ResourceLocation("computercraft", "block/turtle_speaker_right");

    public TurtleSpeaker(ResourceLocation id) {
        super(id, TurtleUpgradeType.PERIPHERAL, (Supplier<? extends IItemProvider>)Registry.ModBlocks.SPEAKER);
    }

    @Override
    public IPeripheral createPeripheral(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return new Peripheral(turtle);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TransformedModel getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return TransformedModel.of(side == TurtleSide.LEFT ? leftModel : rightModel);
    }

    @Override
    public void update(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide turtleSide) {
        IPeripheral turtlePeripheral = turtle.getPeripheral(turtleSide);
        if (turtlePeripheral instanceof Peripheral) {
            ((Peripheral)turtlePeripheral).update();
        }
    }

    private static class Peripheral
    extends UpgradeSpeakerPeripheral {
        ITurtleAccess turtle;

        Peripheral(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        @Override
        @Nonnull
        public SpeakerPosition getPosition() {
            return SpeakerPosition.of(this.turtle.getWorld(), Vector3d.func_237489_a_((Vector3i)this.turtle.getPosition()));
        }

        @Override
        public boolean equals(IPeripheral other) {
            return this == other || other instanceof Peripheral && this.turtle == ((Peripheral)other).turtle;
        }
    }
}

