/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.util.BasicRecipeSerializer;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;

public final class ImpostorRecipe
extends ShapedRecipe {
    private final String group;
    public static final IRecipeSerializer<ImpostorRecipe> SERIALIZER = new BasicRecipeSerializer<ImpostorRecipe>(){

        public ImpostorRecipe fromJson(@Nonnull ResourceLocation identifier, @Nonnull JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ShapedRecipe recipe = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(identifier, json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            return new ImpostorRecipe(identifier, group, recipe.func_192403_f(), recipe.func_192404_g(), recipe.func_192400_c(), result);
        }

        public ImpostorRecipe fromNetwork(@Nonnull ResourceLocation identifier, @Nonnull PacketBuffer buf) {
            int width = buf.func_150792_a();
            int height = buf.func_150792_a();
            String group = buf.func_150789_c(Short.MAX_VALUE);
            NonNullList items = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < items.size(); ++k) {
                items.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buf));
            }
            ItemStack result = buf.func_150791_c();
            return new ImpostorRecipe(identifier, group, width, height, items, result);
        }

        public void toNetwork(@Nonnull PacketBuffer buf, @Nonnull ImpostorRecipe recipe) {
            buf.func_150787_b(recipe.getRecipeWidth());
            buf.func_150787_b(recipe.getRecipeHeight());
            buf.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buf);
            }
            buf.func_150788_a(recipe.func_77571_b());
        }
    };

    private ImpostorRecipe(@Nonnull ResourceLocation id, @Nonnull String group, int width, int height, NonNullList<Ingredient> ingredients, @Nonnull ItemStack result) {
        super(id, group, width, height, ingredients, result);
        this.group = group;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group;
    }

    public boolean func_77569_a(@Nonnull CraftingInventory inv, @Nonnull World world) {
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull CraftingInventory inventory) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

