/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft")
public final class TickScheduler {
    private static final Queue<Token> toTick = new ConcurrentLinkedDeque<Token>();

    private TickScheduler() {
    }

    public static void schedule(Token token) {
        World world = token.owner.func_145831_w();
        if (world != null && !world.field_72995_K && !token.scheduled.getAndSet(true)) {
            toTick.add(token);
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        Token token;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        while ((token = toTick.poll()) != null) {
            token.scheduled.set(false);
            TileEntity blockEntity = token.owner;
            if (blockEntity.func_145837_r()) continue;
            World world = blockEntity.func_145831_w();
            BlockPos pos = blockEntity.func_174877_v();
            if (world == null || !world.isAreaLoaded(pos, 0) || world.func_175625_s(pos) != blockEntity) continue;
            world.func_205220_G_().func_205360_a(pos, (Object)blockEntity.func_195044_w().func_177230_c(), 0);
        }
    }

    public static class Token {
        final TileEntity owner;
        final AtomicBoolean scheduled = new AtomicBoolean();

        public Token(TileEntity owner) {
            this.owner = owner;
        }
    }
}

