/*
 * Decompiled with CFR 0.152.
 */
package forge;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import forge.NuminaOBJModel;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.obj.LineReader;
import net.minecraftforge.client.model.obj.MaterialLibrary;

public class NuminaOBJLoader
implements IModelLoader<NuminaOBJModel> {
    public static NuminaOBJLoader INSTANCE = new NuminaOBJLoader();
    private final Map<NuminaOBJModel.ModelSettings, NuminaOBJModel> modelCache = Maps.newHashMap();
    private final Map<ResourceLocation, MaterialLibrary> materialCache = Maps.newHashMap();
    private IResourceManager manager = Minecraft.func_71410_x().func_195551_G();

    public void func_195410_a(IResourceManager resourceManager) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.manager = resourceManager;
    }

    public NuminaOBJModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("model")) {
            throw new RuntimeException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocation = modelContents.get("model").getAsString();
        boolean detectCullableFaces = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"detectCullableFaces", (boolean)true);
        boolean diffuseLighting = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"diffuseLighting", (boolean)false);
        boolean flipV = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"flip-v", (boolean)false);
        boolean ambientToFullbright = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"ambientToFullbright", (boolean)true);
        String materialLibraryOverrideLocation = modelContents.has("materialLibraryOverride") ? JSONUtils.func_151200_h((JsonObject)modelContents, (String)"materialLibraryOverride") : null;
        return this.loadModel(new NuminaOBJModel.ModelSettings(new ResourceLocation(modelLocation), detectCullableFaces, diffuseLighting, flipV, ambientToFullbright, materialLibraryOverrideLocation));
    }

    public NuminaOBJModel loadModel(NuminaOBJModel.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            IResource resource;
            try {
                resource = this.manager.func_199002_a(settings.modelLocation);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not find OBJ model", e);
            }
            try (LineReader rdr = new LineReader(resource);){
                NuminaOBJModel numinaOBJModel = new NuminaOBJModel(rdr, settings);
                return numinaOBJModel;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read OBJ model", e);
            }
        });
    }

    public MaterialLibrary loadMaterialLibrary(ResourceLocation materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            IResource resource;
            try {
                resource = this.manager.func_199002_a(location);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not find OBJ material library", e);
            }
            try (LineReader rdr = new LineReader(resource);){
                MaterialLibrary materialLibrary = new MaterialLibrary(rdr);
                return materialLibrary;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read OBJ material library", e);
            }
        });
    }
}

