/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable;

import com.mojang.blaze3d.matrix.MatrixStack;
import lehjr.numina.client.gui.clickable.IClickable;
import lehjr.numina.client.gui.gemoetry.DrawableArrow;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.client.gui.gemoetry.RelativeRect;
import lehjr.numina.common.math.Colour;

public class ClickableArrow
extends DrawableArrow
implements IClickable {
    protected IClickable.IPressable onPressed;
    protected IClickable.IReleasable onReleased;
    protected final Colour backgroundColourNotHighlighted;
    protected final Colour backgroundColourHighlighted;
    protected boolean isEnabled = true;
    protected boolean isVisible = true;

    public ClickableArrow(float left, float top, float right, float bottom, boolean growFromMiddle, Colour backgroundColour, Colour backgroundColourHighlighted, Colour borderColour) {
        super(left, top, right, bottom, growFromMiddle, backgroundColour, borderColour);
        this.backgroundColourNotHighlighted = backgroundColour;
        this.backgroundColourHighlighted = backgroundColourHighlighted;
    }

    public ClickableArrow(float left, float top, float right, float bottom, Colour backgroundColour, Colour backgroundColourHighlighted, Colour borderColour) {
        super(left, top, right, bottom, backgroundColour, borderColour);
        this.backgroundColourNotHighlighted = backgroundColour;
        this.backgroundColourHighlighted = backgroundColourHighlighted;
    }

    public ClickableArrow(MusePoint2D ul, MusePoint2D br, Colour backgroundColour, Colour backgroundColourHighlighted, Colour borderColour) {
        super(ul, br, backgroundColour, borderColour);
        this.backgroundColourNotHighlighted = backgroundColour;
        this.backgroundColourHighlighted = backgroundColourHighlighted;
    }

    public ClickableArrow(RelativeRect ref, Colour backgroundColour, Colour backgroundColourHighlighted, Colour borderColour) {
        super(ref, backgroundColour, borderColour);
        this.backgroundColourNotHighlighted = backgroundColour;
        this.backgroundColourHighlighted = backgroundColourHighlighted;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        if (this.isVisible) {
            super.setBackgroundColour(this.hitBox(mouseX, mouseY) ? this.backgroundColourHighlighted : this.backgroundColourNotHighlighted);
            super.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
        }
    }

    @Override
    public MusePoint2D getPosition() {
        return this.center();
    }

    @Override
    public boolean hitBox(double x, double y) {
        if (this.isVisible() && this.isEnabled()) {
            return x >= this.left() && x <= this.right() && y >= this.top() && y <= this.bottom();
        }
        return false;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void onReleased() {
        if (this.isVisible && this.isEnabled && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    @Override
    public void onPressed() {
        if (this.isVisible && this.isEnabled && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }
}

