/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.gemoetry;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.common.math.Colour;
import org.lwjgl.BufferUtils;

public class GradientAndArcCalculator {
    public static FloatBuffer getSphereVertices(int detail, float radius) {
        int stacks = detail;
        int slices = detail;
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)(stacks * (slices << 1) * 6));
        float stackStep = (float)(Math.PI / (double)stacks);
        float sliceStep = (float)(Math.PI / (double)slices);
        for (int i = 0; i < stacks; ++i) {
            float alpha0 = (float)(-1.5707963267948966 + (double)((float)i * stackStep));
            float alpha1 = alpha0 + stackStep;
            float r0 = (float)((double)radius * Math.cos(alpha0));
            float r1 = (float)((double)radius * Math.cos(alpha1));
            float y0 = (float)((double)radius * Math.sin(alpha0));
            float y1 = (float)((double)radius * Math.sin(alpha1));
            for (int j = 0; j < slices << 1; ++j) {
                float beta = (float)j * sliceStep;
                float x0 = (float)((double)r0 * Math.cos(beta));
                float x1 = (float)((double)r1 * Math.cos(beta));
                float z0 = (float)((double)(-r0) * Math.sin(beta));
                float z1 = (float)((double)(-r1) * Math.sin(beta));
                vertices.put(x0);
                vertices.put(y0);
                vertices.put(z0);
                vertices.put(x1);
                vertices.put(y1);
                vertices.put(z1);
            }
        }
        vertices.flip();
        return vertices;
    }

    public static FloatBuffer getArcPoints(float startangle, float endangle, float radius, float xoffset, float yoffset, float zoffset) {
        int numVertices = (int)Math.ceil(Math.abs((double)((endangle - startangle) * 2.0f) * Math.PI));
        float theta = (endangle - startangle) / (float)numVertices;
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(numVertices * 3));
        float x = radius * (float)Math.sin(startangle);
        float y = radius * (float)Math.cos(startangle);
        float tf = (float)Math.tan(theta);
        float rf = (float)Math.cos(theta);
        for (int i = 0; i < numVertices; ++i) {
            buffer.put(x + xoffset);
            buffer.put(y + yoffset);
            buffer.put(zoffset);
            float tx = y;
            float ty = -x;
            x += tx * tf;
            y += ty * tf;
            x *= rf;
            y *= rf;
        }
        buffer.flip();
        return buffer;
    }

    public static FloatBuffer getArcPoints(float startangle, float endangle, float radius, float xoffset, float yoffset) {
        int numVertices = (int)Math.ceil(Math.abs((double)((endangle - startangle) * 2.0f) * Math.PI));
        float theta = (endangle - startangle) / (float)numVertices;
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(numVertices * 2));
        float x = radius * (float)Math.sin(startangle);
        float y = radius * (float)Math.cos(startangle);
        float tf = (float)Math.tan(theta);
        float rf = (float)Math.cos(theta);
        for (int i = 0; i < numVertices; ++i) {
            buffer.put(x + xoffset);
            buffer.put(y + yoffset);
            float tx = y;
            float ty = -x;
            x += tx * tf;
            y += ty * tf;
            x *= rf;
            y *= rf;
        }
        buffer.flip();
        return buffer;
    }

    public static List<MusePoint2D> pointsInLine(int num, MusePoint2D a, MusePoint2D b) {
        ArrayList<MusePoint2D> points = new ArrayList<MusePoint2D>();
        switch (num) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                points.add(b.minus(a).times(0.5).plus(a));
                break;
            }
            default: {
                MusePoint2D step = b.minus(a).times(1.0f / (float)(num + 1));
                for (int i = 0; i < num; ++i) {
                    points.add(a.plus(step.times(i + 1)));
                }
            }
        }
        return points;
    }

    public static List<MusePoint2D> pointsInLine(int num, MusePoint2D a, MusePoint2D b, double minSpacingX, double minSpacingY) {
        ArrayList<MusePoint2D> points = new ArrayList<MusePoint2D>();
        switch (num) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                points.add(b.minus(a).times(0.5).plus(a));
                break;
            }
            default: {
                MusePoint2D step = b.minus(a).times(1.0f / (float)(num + 1));
                if (step.getX() < 0.0) {
                    step.setX(Math.min(-minSpacingX, step.x));
                } else {
                    step.setX(Math.max(minSpacingX, step.x));
                }
                if (step.getY() < 0.0) {
                    step.setY(Math.min(-minSpacingY, step.y));
                } else {
                    step.setY(Math.max(minSpacingY, step.y));
                }
                for (int i = 0; i < num; ++i) {
                    points.add(a.plus(step.times(i + 1)));
                }
            }
        }
        return points;
    }

    public static FloatBuffer getColourGradient(Colour c1, Colour c2, int numsegments) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(numsegments * 4));
        if (c1.equals(c2)) {
            for (double i = 0.0; i < (double)numsegments; i += 1.0) {
                buffer.put(c1.r);
                buffer.put(c1.g);
                buffer.put(c1.b);
                buffer.put(c1.a);
            }
        } else {
            for (double i = 0.0; i < (double)numsegments; i += 1.0) {
                Colour c3 = c1.interpolate(c2, (float)(i / (double)numsegments));
                buffer.put(c3.r);
                buffer.put(c3.g);
                buffer.put(c3.b);
                buffer.put(c3.a);
            }
        }
        buffer.flip();
        return buffer;
    }
}

