/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.model.obj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.client.model.obj.OBJBakedPart;
import lehjr.numina.client.model.obj.OBJPartData;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class OBJBakedCompositeModel
implements IDynamicBakedModel {
    private final ImmutableMap<String, OBJBakedPart> bakedParts;
    private final boolean isAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean diffuseLighting;
    private final TextureAtlasSprite particle;
    private final ItemOverrideList overrides;
    private final IModelTransform transforms;

    public OBJBakedCompositeModel(boolean diffuseLighting, boolean isGui3d, boolean isAmbientOcclusion, TextureAtlasSprite particle, ImmutableMap<String, OBJBakedPart> bakedParts, IModelTransform combinedTransform, ItemOverrideList overrides) {
        this.diffuseLighting = diffuseLighting;
        this.isGui3d = isGui3d;
        this.isAmbientOcclusion = isAmbientOcclusion;
        this.bakedParts = bakedParts;
        this.particle = particle;
        this.transforms = combinedTransform;
        this.overrides = overrides;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : this.bakedParts.entrySet()) {
            builder.addAll(((OBJBakedPart)((Object)entry.getValue())).getQuads(state, side, rand, OBJPartData.getOBJPartData(extraData, (String)entry.getKey())));
        }
        return builder.build();
    }

    public IModelTransform getModelTransforms() {
        return this.transforms;
    }

    public boolean func_177555_b() {
        return this.isAmbientOcclusion;
    }

    public boolean func_177556_c() {
        return this.isGui3d;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelTransform)this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType, (MatrixStack)mat);
    }

    @Nullable
    public OBJBakedPart getPart(String name) {
        return (OBJBakedPart)((Object)this.bakedParts.get((Object)name));
    }
}

