/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.client.gui.clickable.IClickable;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.client.gui.gemoetry.SwirlyMuseCircle;
import lehjr.numina.client.render.BillboardHelper;
import lehjr.numina.common.math.Colour;
import lehjr.numina.common.string.StringUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public abstract class NuminaRenderer {
    protected static SwirlyMuseCircle selectionCircle;
    static boolean messagedAboutSlick;

    public static ItemRenderer getItemRenderer() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    public TextureManager getTextureManager() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    static IBakedModel getModel(@Nonnull ItemStack itemStack) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return NuminaRenderer.getItemRenderer().func_184393_a(itemStack, player.field_70170_p, (LivingEntity)player);
    }

    public static void drawCircleAround(MatrixStack matrixStack, double xoffset, double yoffset, double radius, float zLevel) {
        if (selectionCircle == null) {
            selectionCircle = new SwirlyMuseCircle(new Colour(0.0f, 1.0f, 0.0f, 0.0f), new Colour(0.8f, 1.0f, 0.8f, 1.0f));
        }
        selectionCircle.draw(matrixStack, radius, xoffset, yoffset, zLevel);
    }

    public static void drawModuleAt(MatrixStack matrixStackIn, double x, double y, @Nonnull ItemStack itemStack, boolean active) {
        if (!itemStack.func_190926_b()) {
            IBakedModel model = NuminaRenderer.getModel(itemStack);
            NuminaRenderer.renderItemModelIntoGUI(itemStack, matrixStackIn, (float)x, (float)y, model, active ? Colour.WHITE : Colour.DARK_GREY.withAlpha(0.5f));
        }
    }

    public static void drawItemAt(double x, double y, @Nonnull ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            NuminaRenderer.getItemRenderer().func_180450_b(itemStack, (int)x, (int)y);
            NuminaRenderer.getItemRenderer().func_180453_a(StringUtils.getFontRenderer(), itemStack, (int)x, (int)y, (String)null);
        }
    }

    public static void drawItemAt(MatrixStack matrixStack, double x, double y, @Nonnull ItemStack itemStack, Colour colour) {
        if (!itemStack.func_190926_b()) {
            Minecraft.func_71410_x().func_175599_af().func_180450_b(itemStack, (int)x, (int)y);
            Minecraft.func_71410_x().func_175599_af().func_180453_a(StringUtils.getFontRenderer(), itemStack, (int)x, (int)y, (String)null);
        }
    }

    protected static void renderItemModelIntoGUI(ItemStack stack, MatrixStack matrixStack, float x, float y, IBakedModel bakedmodel, Colour colour) {
        boolean flag;
        RenderSystem.pushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.translatef((float)x, (float)y, (float)(100.0f + Minecraft.func_71410_x().func_175599_af().field_77023_b));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        IRenderTypeBuffer.Impl bufferSource = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        NuminaRenderer.renderItem(stack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, (IRenderTypeBuffer)bufferSource, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel, colour);
        bufferSource.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    public static void renderItem(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn, Colour colour) {
        if (!itemStackIn.func_190926_b()) {
            boolean flag;
            matrixStackIn.func_227860_a_();
            boolean bl = flag = transformTypeIn == ItemCameraTransforms.TransformType.GUI || transformTypeIn == ItemCameraTransforms.TransformType.GROUND || transformTypeIn == ItemCameraTransforms.TransformType.FIXED;
            if (itemStackIn.func_77973_b() == Items.field_203184_eO && flag) {
                modelIn = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            modelIn = ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStackIn, (IBakedModel)modelIn, (ItemCameraTransforms.TransformType)transformTypeIn, (boolean)leftHand);
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (!modelIn.func_188618_c() && (itemStackIn.func_77973_b() != Items.field_203184_eO || flag)) {
                Block block;
                boolean flag1 = transformTypeIn != ItemCameraTransforms.TransformType.GUI && !transformTypeIn.func_241716_a_() && itemStackIn.func_77973_b() instanceof BlockItem ? !((block = ((BlockItem)itemStackIn.func_77973_b()).func_179223_d()) instanceof BreakableBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                if (modelIn.isLayered()) {
                    ForgeHooksClient.drawItemLayered((ItemRenderer)Minecraft.func_71410_x().func_175599_af(), (IBakedModel)modelIn, (ItemStack)itemStackIn, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn, (boolean)flag1);
                } else {
                    IVertexBuilder ivertexbuilder;
                    RenderType rendertype = RenderTypeLookup.func_239219_a_((ItemStack)itemStackIn, (boolean)flag1);
                    if (itemStackIn.func_77973_b() == Items.field_151111_aL && itemStackIn.func_77962_s()) {
                        matrixStackIn.func_227860_a_();
                        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
                        if (transformTypeIn == ItemCameraTransforms.TransformType.GUI) {
                            matrixstack$entry.func_227870_a_().func_226592_a_(0.5f);
                        } else if (transformTypeIn.func_241716_a_()) {
                            matrixstack$entry.func_227870_a_().func_226592_a_(0.75f);
                        }
                        if (flag1) {
                            Minecraft.func_71410_x().func_175599_af();
                            ivertexbuilder = ItemRenderer.func_241732_b_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (MatrixStack.Entry)matrixstack$entry);
                        } else {
                            Minecraft.func_71410_x().func_175599_af();
                            ivertexbuilder = ItemRenderer.func_241731_a_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (MatrixStack.Entry)matrixstack$entry);
                        }
                        matrixStackIn.func_227865_b_();
                    } else if (flag1) {
                        Minecraft.func_71410_x().func_175599_af();
                        ivertexbuilder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.func_77962_s());
                    } else {
                        Minecraft.func_71410_x().func_175599_af();
                        ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.func_77962_s());
                    }
                    NuminaRenderer.renderModel(modelIn, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder, colour);
                }
            } else {
                itemStackIn.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    public static void renderModel(IBakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IVertexBuilder bufferIn, Colour colour) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            NuminaRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, direction, random), stack, combinedLightIn, combinedOverlayIn, colour);
        }
        random.setSeed(42L);
        NuminaRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, (Direction)null, random), stack, combinedLightIn, combinedOverlayIn, colour);
    }

    public static void renderQuads(MatrixStack matrixStackIn, IVertexBuilder bufferIn, List<BakedQuad> quadsIn, ItemStack itemStackIn, int combinedLightIn, int combinedOverlayIn, Colour colour) {
        if (colour == null) {
            Minecraft.func_71410_x().func_175599_af().func_229112_a_(matrixStackIn, bufferIn, quadsIn, itemStackIn, combinedLightIn, combinedOverlayIn);
        } else {
            MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
            for (BakedQuad bakedquad : quadsIn) {
                bufferIn.addVertexData(matrixstack$entry, bakedquad, colour.r, colour.g, colour.b, colour.a, combinedLightIn, combinedOverlayIn, true);
            }
        }
    }

    public void renderGuiItemDecorations(MatrixStack matrixStack, FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity clientplayerentity;
            float f3;
            if (stack.func_190916_E() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, (double)(Minecraft.func_71410_x().func_175599_af().field_77023_b + 200.0f));
                IRenderTypeBuffer.Impl typeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                fr.func_228079_a_(s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF, true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)typeBuffer, false, 0, 0xF000F0);
                typeBuffer.func_228461_a_();
                matrixStack.func_227865_b_();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                this.draw(bufferbuilder, matrixStack.func_227866_c_().func_227870_a_(), xPosition + 2, yPosition + 13, 13.0f, 2, 0, 0, 0, 255);
                this.draw(bufferbuilder, matrixStack.func_227866_c_().func_227870_a_(), xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = f3 = (clientplayerentity = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : clientplayerentity.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                this.draw(bufferbuilder1, matrixStack.func_227866_c_().func_227870_a_(), xPosition, yPosition + MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16.0f, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private void draw(BufferBuilder renderer, Matrix4f matrix4f, float x, float y, float width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_227888_a_(matrix4f, x + 0.0f, y + 0.0f, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(matrix4f, x + 0.0f, y + (float)height, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(matrix4f, x + width, y + (float)height, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(matrix4f, x + width, y + 0.0f, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawLineBetween(IClickable firstClickable, IClickable secondClickable, Colour gradientColour, float zLevel) {
        MusePoint2D secondpoint;
        MusePoint2D firstpoint;
        long varia = System.currentTimeMillis() % 2000L - 1000L;
        float gradientRatio = 1.0f - (float)((varia + 1000L) % 1000L) / 1000.0f;
        MusePoint2D midpoint = firstClickable.getPosition().minus(secondClickable.getPosition()).times((float)Math.abs((double)varia / 1000.0)).plus(secondClickable.getPosition());
        if (varia < 0L) {
            firstpoint = secondClickable.getPosition();
            secondpoint = firstClickable.getPosition();
        } else {
            firstpoint = firstClickable.getPosition();
            secondpoint = secondClickable.getPosition();
        }
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_(midpoint.getX(), midpoint.getY(), (double)(zLevel + 10.0f)).func_227885_a_(gradientColour.r, gradientColour.g, gradientColour.b, gradientRatio).func_181675_d();
        buffer.func_225582_a_(firstpoint.getX(), firstpoint.getY(), (double)(zLevel + 10.0f)).func_227885_a_(gradientColour.r, gradientColour.g, gradientColour.b, 0.0f).func_181675_d();
        buffer.func_225582_a_(secondpoint.getX(), secondpoint.getY(), (double)(zLevel + 10.0f)).func_227885_a_(gradientColour.r, gradientColour.g, gradientColour.b, gradientRatio).func_181675_d();
        buffer.func_225582_a_(midpoint.getX(), midpoint.getY(), (double)(zLevel + 10.0f)).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void unRotate() {
        BillboardHelper.unRotate();
    }

    public static void drawMPDLightning(MatrixStack poseStack, float x1, float y1, float z1, float x2, float y2, float z2, Colour colour, double displacement, double detail) {
        Matrix4f matrix4f = poseStack.func_227866_c_().func_227870_a_();
        NuminaRenderer.drawMPDLightning(matrix4f, x1, y1, z1, x2, y2, z2, colour, displacement * 0.5, detail);
    }

    public static void drawMPDLightning(Matrix4f matrix4f, float x1, float y1, float z1, float x2, float y2, float z2, Colour colour, double displacement, double detail) {
        if (displacement < detail) {
            RenderSystem.disableTexture();
            RenderSystem.disableDepthTest();
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
            Tessellator tesselator = RenderSystem.renderThreadTesselator();
            BufferBuilder bufferbuilder = tesselator.func_178180_c();
            bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            colour.addToVertex(bufferbuilder.func_227888_a_(matrix4f, x1, y1, z1)).func_181675_d();
            colour.addToVertex(bufferbuilder.func_227888_a_(matrix4f, x2, y2, z2)).func_181675_d();
            tesselator.func_78381_a();
            RenderSystem.enableDepthTest();
            RenderSystem.enableTexture();
            RenderSystem.depthMask((boolean)true);
        } else {
            float mid_x = (x1 + x2) * 0.5f;
            float mid_y = (y1 + y2) * 0.5f;
            float mid_z = (z1 + z2) * 0.5f;
            mid_x = (float)((double)mid_x + (Math.random() - 0.5) * displacement);
            mid_y = (float)((double)mid_y + (Math.random() - 0.5) * displacement);
            mid_z = (float)((double)mid_z + (Math.random() - 0.5) * displacement);
            NuminaRenderer.drawMPDLightning(matrix4f, x1, y1, z1, mid_x, mid_y, mid_z, colour, displacement * 0.5, detail);
            NuminaRenderer.drawMPDLightning(matrix4f, mid_x, mid_y, mid_z, x2, y2, z2, colour, displacement * 0.5, detail);
        }
    }

    static {
        messagedAboutSlick = false;
    }
}

