/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.sound;

import java.util.HashMap;
import lehjr.numina.client.sound.MovingSoundPlayer;
import lehjr.numina.common.config.NuminaSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Musique {
    private static HashMap<String, MovingSoundPlayer> soundMap = new HashMap();

    public static SoundHandler mcsound() {
        return Minecraft.func_71410_x().func_147118_V();
    }

    public static void playClientSound(SoundEvent soundEvt, float volumeIn) {
        if (NuminaSettings.useSounds()) {
            Musique.mcsound().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)soundEvt, (float)volumeIn));
        }
    }

    public static String makeSoundString(PlayerEntity player, SoundEvent soundEvt) {
        return Musique.makeSoundString(player, soundEvt.getRegistryName());
    }

    public static String makeSoundString(PlayerEntity player, ResourceLocation soundname) {
        return player.func_110124_au().toString() + soundname;
    }

    public static void playerSound(PlayerEntity player, SoundEvent soundEvt, SoundCategory categoryIn, float volume, Float pitch, Boolean continuous) {
        pitch = Float.valueOf(pitch != null ? pitch.floatValue() : 1.0f);
        continuous = continuous != null ? continuous : true;
        if (NuminaSettings.useSounds() && soundEvt != null) {
            String soundID = Musique.makeSoundString(player, soundEvt);
            MovingSoundPlayer sound = soundMap.get(soundID);
            if (sound != null && (sound.func_147667_k() || !sound.func_147657_c())) {
                Musique.stopPlayerSound(player, soundEvt);
                sound = null;
            }
            if (sound != null) {
                sound.updateVolume(volume).updatePitch(pitch.floatValue()).updateRepeat(continuous);
            } else {
                MovingSoundPlayer newsound = new MovingSoundPlayer(soundEvt, categoryIn, player, volume * 2.0f, pitch.floatValue(), continuous);
                Musique.mcsound().func_147682_a((ISound)newsound);
                soundMap.put(soundID, newsound);
            }
        }
    }

    public static void stopPlayerSound(PlayerEntity player, SoundEvent soundEvt) {
        if (NuminaSettings.useSounds()) {
            String soundID = Musique.makeSoundString(player, soundEvt);
            MovingSoundPlayer sound = soundMap.get(soundID);
            if (sound != null) {
                sound.stopPlaying();
                Musique.mcsound().func_147683_b((ISound)sound);
            }
            soundMap.remove(soundID);
        }
    }
}

