/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.integration.scannable;

import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.rightclick.IRightClickModule;
import lehjr.numina.common.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.numina.common.integration.scannable.MPSScannerContainerProvider;
import lehjr.numina.common.item.ItemUtils;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.client.audio.SoundManager;
import li.cil.scannable.common.capabilities.CapabilityScannerModule;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.inventory.ItemHandlerScanner;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TickingScanner
extends PlayerTickModule
implements IRightClickModule {
    public TickingScanner(@Nonnull ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> moduleConfigGetterIn) {
        super(module, category, target, moduleConfigGetterIn, true);
    }

    @Override
    public int getUseDuration() {
        return this.getModuleStack().func_77988_m();
    }

    public ActionResult use(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
        int totalEnergy;
        int energyNeeded;
        ItemStack module = ItemUtils.getActiveModuleOrEmpty(itemStackIn);
        if (!worldIn.func_201670_d() && (energyNeeded = ElectricItemUtils.chargeItem(module, totalEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)playerIn), true)) > 0) {
            energyNeeded = ElectricItemUtils.drainPlayerEnergy((LivingEntity)playerIn, energyNeeded, false);
            ElectricItemUtils.chargeItem(module, energyNeeded, false);
        }
        if (playerIn.func_225608_bj_()) {
            if (!worldIn.field_72995_K) {
                MPSScannerContainerProvider containerProvider = new MPSScannerContainerProvider(playerIn, hand);
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)containerProvider, buffer -> buffer.func_179249_a((Enum)hand));
            }
        } else {
            NonNullList<ItemStack> modules = TickingScanner.collectModules(module);
            if (modules.isEmpty()) {
                if (worldIn.field_72995_K) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("message.scannable.no_scan_modules"));
                }
                playerIn.func_184811_cZ().func_185145_a(itemStackIn.func_77973_b(), 10);
                return ActionResult.func_226251_d_((Object)itemStackIn);
            }
            if (!TickingScanner.tryConsumeEnergy(playerIn, modules, true)) {
                if (worldIn.field_72995_K) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("message.scannable.not_enough_energy"));
                }
                playerIn.func_184811_cZ().func_185145_a(itemStackIn.func_77973_b(), 10);
                return ActionResult.func_226251_d_((Object)itemStackIn);
            }
            playerIn.func_184598_c(hand);
            if (worldIn.field_72995_K) {
                ScanManager.INSTANCE.beginScan(playerIn, modules);
                SoundManager.INSTANCE.playChargingSound();
            }
        }
        return ActionResult.func_226248_a_((Object)itemStackIn);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, World world, LivingEntity entity) {
        NonNullList<ItemStack> modules;
        if (!(entity instanceof PlayerEntity)) {
            return stack;
        }
        if (world.field_72995_K) {
            SoundCanceler.cancelEquipSound();
        }
        if ((modules = TickingScanner.collectModules(this.module)).isEmpty()) {
            return stack;
        }
        boolean hasEnergy = TickingScanner.tryConsumeEnergy((PlayerEntity)entity, modules, false);
        if (world.field_72995_K) {
            SoundManager.INSTANCE.stopChargingSound();
            if (hasEnergy) {
                ScanManager.INSTANCE.updateScan((Entity)entity, true);
                SoundManager.INSTANCE.playActivateSound();
            } else {
                ScanManager.INSTANCE.cancelScan();
            }
        }
        PlayerEntity player = (PlayerEntity)entity;
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 40);
        return stack;
    }

    @Override
    public void releaseUsing(ItemStack stack, World world, LivingEntity entity, int timeLeft) {
        if (world.field_72995_K) {
            ScanManager.INSTANCE.cancelScan();
            SoundManager.INSTANCE.stopChargingSound();
        }
    }

    @Override
    public void onPlayerTickActive(PlayerEntity player, @Nonnull ItemStack item) {
        if (player.func_184587_cr() && player.func_130014_f_().field_72995_K) {
            ScanManager.INSTANCE.updateScan((Entity)player, false);
        }
    }

    @Override
    public boolean isModuleOnline() {
        return true;
    }

    @Override
    public void updateFromNBT() {
    }

    private static NonNullList<ItemStack> collectModules(ItemStack scanner) {
        NonNullList modules = NonNullList.func_191196_a();
        scanner.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(handler -> handler instanceof ItemHandlerScanner).ifPresent(handler -> {
            IItemHandler activeModules = ((ItemHandlerScanner)handler).getActiveModules();
            boolean hasScannerModules = false;
            for (int slot = 0; slot < activeModules.getSlots(); ++slot) {
                ItemStack module = activeModules.getStackInSlot(slot);
                if (module.func_190926_b()) continue;
                modules.add((Object)module);
                LazyOptional capability = module.getCapability(CapabilityScannerModule.SCANNER_MODULE_CAPABILITY);
                hasScannerModules |= capability.map(ScannerModule::hasResultProvider).orElse(false).booleanValue();
            }
            if (!hasScannerModules) {
                modules.clear();
            }
        });
        return modules;
    }

    private static boolean tryConsumeEnergy(PlayerEntity player, List<ItemStack> modules, boolean simulate) {
        if (!Settings.useEnergy) {
            return true;
        }
        if (player.func_184812_l_()) {
            return true;
        }
        int totalCostAccumulator = 0;
        for (ItemStack module : modules) {
            totalCostAccumulator += TickingScanner.getModuleEnergyCost(player, module);
        }
        int totalCost = totalCostAccumulator;
        int extracted = ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, totalCost, simulate);
        return extracted >= totalCost;
    }

    static int getModuleEnergyCost(PlayerEntity player, ItemStack stack) {
        LazyOptional module = stack.getCapability(CapabilityScannerModule.SCANNER_MODULE_CAPABILITY);
        return module.map(p -> p.getEnergyCost(player, stack)).orElse(0);
    }

    private static enum SoundCanceler {
        INSTANCE;


        public static void cancelEquipSound() {
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }

        @SubscribeEvent
        public void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
            if (event.getSound() == SoundEvents.field_187719_p) {
                event.setCanceled(true);
            }
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

