/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.network.packets;

import java.util.function.Supplier;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class TweakRequestDoublePacket {
    protected EquipmentSlotType type;
    protected ResourceLocation moduleName;
    protected String tweakName;
    protected double tweakValue;

    public TweakRequestDoublePacket() {
    }

    public TweakRequestDoublePacket(EquipmentSlotType type, ResourceLocation moduleRegName, String tweakName, double tweakValue) {
        this.type = type;
        this.moduleName = moduleRegName;
        this.tweakName = tweakName;
        this.tweakValue = tweakValue;
    }

    public static void encode(TweakRequestDoublePacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_179249_a((Enum)msg.type);
        packetBuffer.func_192572_a(msg.moduleName);
        packetBuffer.func_180714_a(msg.tweakName);
        packetBuffer.writeDouble(msg.tweakValue);
    }

    public static TweakRequestDoublePacket decode(PacketBuffer packetBuffer) {
        return new TweakRequestDoublePacket((EquipmentSlotType)packetBuffer.func_179257_a(EquipmentSlotType.class), packetBuffer.func_192575_l(), packetBuffer.func_150789_c(500), packetBuffer.readDouble());
    }

    public static void handle(TweakRequestDoublePacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ResourceLocation moduleName = message.moduleName;
            String tweakName = message.tweakName;
            double tweakValue = message.tweakValue;
            if (moduleName != null && tweakName != null) {
                EquipmentSlotType type = message.type;
                player.func_184582_a(type).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iItemHandler -> iItemHandler.setModuleTweakDouble(moduleName, tweakName, tweakValue));
                player.field_71071_by.func_70296_d();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

