/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.util.ProxyUtils;
import cofh.lib.network.packet.IPacketClient;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.tileentity.ITilePacketHandler;
import cofh.lib.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileGuiPacket
extends PacketBase
implements IPacketClient {
    protected BlockPos pos;
    protected PacketBuffer buffer;

    public TileGuiPacket() {
        super(2, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        World world = ProxyUtils.getClientWorld();
        if (world == null) {
            CoFHCore.LOG.error("Client world is null! (Is this being called on the server?)");
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof ITilePacketHandler) {
            ((ITilePacketHandler)tile).handleGuiPacket(this.buffer);
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.buffer = buf;
        this.pos = this.buffer.func_179259_c();
    }

    public static void sendToClient(ITilePacketHandler tile, ServerPlayerEntity player) {
        if (tile.world() == null || Utils.isClientWorld(tile.world())) {
            return;
        }
        TileGuiPacket packet = new TileGuiPacket();
        packet.pos = tile.pos();
        packet.buffer = tile.getGuiPacket(new PacketBuffer(Unpooled.buffer()));
        packet.sendToPlayer(player);
    }
}

