/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.control;

import cofh.core.network.packet.server.SecurityControlPacket;
import cofh.core.util.control.ISecurableTile;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.control.ISecurable;
import cofh.lib.util.helpers.SecurityHelper;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class SecurityControlModule
implements ISecurable {
    protected ISecurableTile tile;
    protected BooleanSupplier enabled;
    protected GameProfile owner = SecurityHelper.DEFAULT_GAME_PROFILE;
    protected ISecurable.AccessMode access = ISecurable.AccessMode.PUBLIC;

    public SecurityControlModule(ISecurableTile tile) {
        this(tile, Constants.TRUE);
    }

    public SecurityControlModule(ISecurableTile tile, BooleanSupplier enabled) {
        this.tile = tile;
        this.enabled = enabled;
    }

    public SecurityControlModule setEnabled(BooleanSupplier enabled) {
        this.enabled = enabled;
        return this;
    }

    public void readFromBuffer(PacketBuffer buffer) {
        this.access = ISecurable.AccessMode.VALUES[buffer.readByte()];
        this.owner = SecurityHelper.DEFAULT_GAME_PROFILE;
        this.setOwner(new GameProfile(buffer.func_179253_g(), buffer.func_150789_c(1024)));
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeByte(this.access.ordinal());
        buffer.func_179252_a(this.owner.getId());
        buffer.func_180714_a(this.owner.getName());
    }

    public SecurityControlModule read(CompoundNBT nbt) {
        CompoundNBT subTag = nbt.func_74775_l("Security");
        if (subTag.func_74764_b("SecUUID")) {
            String uuid = subTag.func_74779_i("SecUUID");
            String name = subTag.func_74779_i("SecName");
            this.owner = new GameProfile(UUID.fromString(uuid), name);
        } else {
            this.owner = SecurityHelper.DEFAULT_GAME_PROFILE;
        }
        this.access = this.isSecurable() ? ISecurable.AccessMode.VALUES[subTag.func_74771_c("SecAccess")] : ISecurable.AccessMode.PUBLIC;
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        if (this.isSecurable()) {
            CompoundNBT subTag = new CompoundNBT();
            subTag.func_74778_a("SecUUID", this.owner.getId().toString());
            subTag.func_74778_a("SecName", this.owner.getName());
            subTag.func_74774_a("SecAccess", (byte)this.access.ordinal());
            nbt.func_218657_a("Security", (INBT)subTag);
        }
        return nbt;
    }

    @Override
    public boolean isSecurable() {
        return this.enabled.getAsBoolean();
    }

    @Override
    public ISecurable.AccessMode getAccess() {
        return this.access;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setAccess(ISecurable.AccessMode access) {
        ISecurable.AccessMode curAccess = this.access;
        this.access = access;
        if (Utils.isClientWorld(this.tile.world())) {
            SecurityControlPacket.sendToServer(this.tile);
            this.access = curAccess;
        } else {
            this.tile.onControlUpdate();
        }
    }

    @Override
    public boolean setOwner(GameProfile profile) {
        if (!this.isSecurable()) {
            return false;
        }
        if (SecurityHelper.isDefaultProfile(this.owner) && !SecurityHelper.isDefaultProfile(profile)) {
            this.owner = profile;
            if (Utils.isServerWorld(this.tile.world())) {
                this.tile.onControlUpdate();
            }
            return true;
        }
        return false;
    }
}

