/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.raytracer;

import cofh.lib.util.raytracer.IndexedVoxelShape;
import cofh.lib.util.raytracer.VoxelShapeRayTraceResult;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;

public class MultiIndexedVoxelShape
extends VoxelShape {
    private final VoxelShape merged;
    private final ImmutableSet<IndexedVoxelShape> shapes;

    public MultiIndexedVoxelShape(ImmutableSet<IndexedVoxelShape> shapes) {
        this(MultiIndexedVoxelShape.mergeAll(shapes), shapes);
    }

    public MultiIndexedVoxelShape(VoxelShape merged, ImmutableSet<IndexedVoxelShape> shapes) {
        super(merged.field_197768_g);
        this.merged = merged;
        this.shapes = shapes;
    }

    public DoubleList func_197757_a(Direction.Axis axis) {
        return this.merged.func_197757_a(axis);
    }

    @Nullable
    public VoxelShapeRayTraceResult clip(Vector3d start, Vector3d end, BlockPos pos) {
        VoxelShapeRayTraceResult closest = null;
        double dist = Double.MAX_VALUE;
        for (IndexedVoxelShape shape : this.shapes) {
            VoxelShapeRayTraceResult hit = shape.clip(start, end, pos);
            if (hit == null || !(dist >= hit.dist)) continue;
            closest = hit;
            dist = hit.dist;
        }
        return closest;
    }

    private static VoxelShape mergeAll(Set<? extends VoxelShape> shapes) {
        Set<? extends VoxelShape> genericsDie = shapes;
        return genericsDie.stream().reduce(VoxelShapes.func_197880_a(), VoxelShapes::func_197872_a);
    }
}

