/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.jei;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidIngredient;
import cofh.thermal.core.client.gui.device.DeviceRockGenScreen;
import cofh.thermal.core.client.gui.device.DeviceTreeExtractorScreen;
import cofh.thermal.core.compat.jei.device.RockGenCategory;
import cofh.thermal.core.compat.jei.device.TreeExtractorCategory;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public class TCoreJeiPlugin
implements IModPlugin {
    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = this.getRecipeManager();
        if (recipeManager == null) {
            return;
        }
        if (ThermalFlags.getFlag("device_tree_extractor").getAsBoolean()) {
            registration.addRecipes(recipeManager.func_215366_a(TCoreRecipeTypes.MAPPING_TREE_EXTRACTOR).values(), TCoreRecipeTypes.ID_MAPPING_TREE_EXTRACTOR);
        }
        if (ThermalFlags.getFlag("device_rock_gen").getAsBoolean()) {
            registration.addRecipes(recipeManager.func_215366_a(TCoreRecipeTypes.MAPPING_ROCK_GEN).values(), TCoreRecipeTypes.ID_MAPPING_ROCK_GEN);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new TreeExtractorCategory(registration.getJeiHelpers().getGuiHelper(), new ItemStack((IItemProvider)TCoreReferences.DEVICE_TREE_EXTRACTOR_BLOCK), TCoreRecipeTypes.ID_MAPPING_TREE_EXTRACTOR)});
        registration.addRecipeCategories(new IRecipeCategory[]{new RockGenCategory(registration.getJeiHelpers().getGuiHelper(), new ItemStack((IItemProvider)TCoreReferences.DEVICE_ROCK_GEN_BLOCK), TCoreRecipeTypes.ID_MAPPING_ROCK_GEN)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        int progressY = 34;
        int progressW = 24;
        int progressH = 16;
        registration.addRecipeClickArea(DeviceTreeExtractorScreen.class, 80, 35, 16, progressH, new ResourceLocation[]{TCoreRecipeTypes.ID_MAPPING_TREE_EXTRACTOR});
        registration.addRecipeClickArea(DeviceRockGenScreen.class, 84, progressY, progressW, progressH, new ResourceLocation[]{TCoreRecipeTypes.ID_MAPPING_ROCK_GEN});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TCoreReferences.DEVICE_TREE_EXTRACTOR_BLOCK), new ResourceLocation[]{TCoreRecipeTypes.ID_MAPPING_TREE_EXTRACTOR});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TCoreReferences.DEVICE_ROCK_GEN_BLOCK), new ResourceLocation[]{TCoreRecipeTypes.ID_MAPPING_ROCK_GEN});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("thermal", "core");
    }

    private RecipeManager getRecipeManager() {
        RecipeManager recipeManager = null;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            recipeManager = world.func_199532_z();
        }
        return recipeManager;
    }

    public static void setInputIngredients(IIngredients ingredients, List<FluidIngredient> inputs) {
        ArrayList<List<FluidStack>> inputLists = new ArrayList<List<FluidStack>>();
        for (FluidIngredient input : inputs) {
            FluidStack[] stacks = input.getFluids();
            List<FluidStack> expandedInput = Arrays.asList(stacks);
            inputLists.add(expandedInput);
        }
        ingredients.setInputLists(VanillaTypes.FLUID, inputLists);
    }

    public static void addDefaultFluidTooltipCallback(IGuiFluidStackGroup group) {
        group.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (FluidHelper.hasPotionTag((FluidStack)ingredient)) {
                FluidHelper.addPotionTooltipStrings((FluidStack)ingredient, (List)tooltip);
            }
        });
    }

    public static int tankSize(int size) {
        return ThermalConfig.jeiBucketTanks ? 1000 : size;
    }

    public static IDrawable tankOverlay(IDrawable overlay) {
        return ThermalConfig.jeiBucketTanks ? null : overlay;
    }
}

