/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.item;

import cam72cam.mod.math.Vec3d;
import cam72cam.mod.model.obj.OBJModel;
import cam72cam.mod.render.ItemRender;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.render.obj.OBJRender;
import cam72cam.mod.resource.Identifier;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL11;

public class ObjItemRender {
    public static Map<Identifier, OBJRender> cache = new HashMap<Identifier, OBJRender>();

    public static ItemRender.IItemModel getModelFor(Identifier id, Vec3d translate, float scale) {
        return ObjItemRender.getModelFor(id, translate, Vec3d.ZERO, scale);
    }

    public static ItemRender.IItemModel getModelFor(Identifier id, Vec3d translate, Vec3d rotation, float scale) {
        return (stack, world) -> new StandardModel().addCustom(() -> {
            if (!cache.containsKey(id)) {
                try {
                    cache.put(id, new OBJRender(new OBJModel(id, 0.0f, null)));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error loading item model...", e);
                }
            }
            OBJRender renderer = cache.get(id);
            try (OpenGL.With matrix = OpenGL.matrix();
                 OpenGL.With tex = renderer.bindTexture();){
                GL11.glTranslated((double)translate.x, (double)translate.y, (double)translate.z);
                GL11.glRotated((double)rotation.x, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)rotation.y, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)rotation.z, (double)0.0, (double)0.0, (double)1.0);
                GL11.glScaled((double)scale, (double)scale, (double)scale);
                renderer.draw();
            }
        });
    }
}

