/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.item;

import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.render.ExpireableList;
import cam72cam.immersiverailroading.render.rail.RailBaseRender;
import cam72cam.immersiverailroading.render.rail.RailBuilderRender;
import cam72cam.immersiverailroading.render.rail.RailRenderUtil;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.render.GlobalRender;
import cam72cam.mod.render.ItemRender;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.world.World;
import org.lwjgl.opengl.GL11;

public class TrackBlueprintItemModel
implements ItemRender.IItemModel {
    private static ExpireableList<String, RailInfo> infoCache = new ExpireableList();

    public StandardModel getModel(World world, ItemStack stack) {
        return new StandardModel().addCustom(() -> TrackBlueprintItemModel.render(stack, world));
    }

    public static void render(ItemStack stack, World world) {
        RailInfo info = new RailInfo(stack, new PlacementInfo(stack, 1.0f, new Vec3d(0.5, 0.5, 0.5)), null);
        info = info.withLength(10);
        try (OpenGL.With matrix = OpenGL.matrix();
             OpenGL.With cull = OpenGL.bool((int)2884, (boolean)false);
             OpenGL.With ligh = OpenGL.bool((int)2896, (boolean)false);){
            if (info.settings.type == TrackItems.TURN || info.settings.type == TrackItems.SWITCH) {
                GL11.glTranslated((double)0.0, (double)0.0, (double)(-0.1 * (double)(info.settings.degrees / 90.0f * 4.0f)));
            }
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
            GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
            double scale = 0.95 / (double)info.settings.length;
            if (info.settings.type == TrackItems.CROSSING) {
                scale = 0.31666666666666665;
            }
            if (info.settings.type == TrackItems.TURNTABLE) {
                scale *= 0.25;
            }
            GL11.glScaled((double)(-scale), (double)(-scale * 2.0), (double)scale);
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
            try (OpenGL.With m = OpenGL.matrix();){
                GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
                RailBaseRender.draw(info, world);
            }
            RailBuilderRender.renderRailBuilder(info, world);
        }
    }

    public static void renderMouseover(Player player, ItemStack stack, Vec3i pos, Vec3d vec, float partialTicks) {
        Vec3d hit = vec.subtract(pos);
        World world = player.getWorld();
        if (BlockUtil.canBeReplaced(world, (pos = pos.up()).down(), true) && (!BlockUtil.isIRRail(world, pos.down()) || (double)((TileRailBase)world.getBlockEntity(pos.down(), TileRailBase.class)).getRailHeight() < 0.5)) {
            pos = pos.down();
        }
        RailInfo info = new RailInfo(stack, new PlacementInfo(stack, player.getRotationYawHead(), hit.subtract(0.0, hit.y, 0.0)), null);
        String key = info.uniqueID + info.placementInfo.placementPosition;
        RailInfo cached = infoCache.get(key);
        if (cached != null) {
            info = cached;
        } else {
            infoCache.put(key, info);
        }
        try (OpenGL.With with = OpenGL.matrix();
             OpenGL.With transparency = OpenGL.transparency((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);){
            Vec3d cameraPos = GlobalRender.getCameraPos((float)partialTicks);
            Vec3d offPos = info.placementInfo.placementPosition.add(pos).subtract(cameraPos);
            GL11.glTranslated((double)offPos.x, (double)offPos.y, (double)offPos.z);
            RailRenderUtil.render(info, world, pos, true);
        }
    }
}

