/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.thirdparty.trackapi;

import cam72cam.immersiverailroading.thirdparty.trackapi.TileEntityTickableTrack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import trackapi.lib.Util;

public interface ITrack {
    public static boolean isRail(cam72cam.mod.world.World world, Vec3i pos) {
        return ITrack.get(world, new Vec3d(pos), true) != null;
    }

    public static ITrack from(final trackapi.lib.ITrack track) {
        if (track == null) {
            return null;
        }
        return new ITrack(){

            @Override
            public double getTrackGauge() {
                return track.getTrackGauge();
            }

            @Override
            public Vec3d getNextPosition(Vec3d pos, Vec3d vel) {
                Vector3d next = track.getNextPosition(pos.internal(), vel.internal());
                return next != null ? new Vec3d(next) : null;
            }
        };
    }

    public static ITrack get(cam72cam.mod.world.World world, Vec3d pos, boolean allowMCRail) {
        trackapi.lib.ITrack track = Util.getTileEntity((World)world.internal, (Vector3d)pos.internal(), (boolean)allowMCRail);
        if (track instanceof TileEntityTickableTrack) {
            return (ITrack)((TileEntityTickableTrack)track).instance();
        }
        return ITrack.from(track);
    }

    public double getTrackGauge();

    public Vec3d getNextPosition(Vec3d var1, Vec3d var2);

    default public trackapi.lib.ITrack to() {
        return new trackapi.lib.ITrack(){

            public double getTrackGauge() {
                return ITrack.this.getTrackGauge();
            }

            public Vector3d getNextPosition(Vector3d pos, Vector3d vel) {
                Vec3d next = ITrack.this.getNextPosition(new Vec3d(pos), new Vec3d(vel));
                return next != null ? next.internal() : null;
            }
        };
    }
}

