/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.tile;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.CraftingMachineMode;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.multiblock.MultiblockRegistry;
import cam72cam.immersiverailroading.net.MultiblockSelectCraftPacket;
import cam72cam.mod.block.BlockEntityTickable;
import cam72cam.mod.energy.Energy;
import cam72cam.mod.energy.IEnergy;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.boundingbox.IBoundingBox;
import cam72cam.mod.item.IInventory;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.item.ItemStackHandler;
import cam72cam.mod.math.Rotation;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.BlockInfo;

public class TileMultiblock
extends BlockEntityTickable {
    @TagField(value="replaced")
    private BlockInfo replaced;
    @TagField(value="offset")
    private Vec3i offset;
    @TagField(value="rotation")
    private Rotation rotation;
    @TagField(value="name")
    private String name;
    @TagField(value="craftMode")
    private CraftingMachineMode craftMode = CraftingMachineMode.STOPPED;
    private long ticks;
    private Multiblock.MultiblockInstance mb;
    @TagField(value="craftProgress")
    private int craftProgress = 0;
    @TagField(value="craftItem")
    private ItemStack craftItem = ItemStack.EMPTY;
    @TagField
    private final ItemStackHandler container = new ItemStackHandler(0);
    @TagField(value="energyStorage")
    private final Energy energy = new Energy(0, 1000);

    public boolean isLoaded() {
        return this.name != null && this.name.length() != 0;
    }

    public void configure(String name, Rotation rot, Vec3i offset, BlockInfo replaced) {
        this.name = name;
        this.rotation = rot;
        this.offset = offset;
        this.replaced = replaced;
        this.container.setSize(this.getMultiblock().getInvSize(offset));
        this.markDirty();
    }

    public void load(TagCompound nbt) {
        this.container.onChanged(slot -> this.markDirty());
        this.container.setSlotLimit(slot -> this.getMultiblock().getSlotLimit(this.offset, (int)slot));
        this.energy.onChanged(() -> ((TileMultiblock)this).markDirty());
    }

    public void update() {
        ++this.ticks;
        if (this.offset != null && this.getMultiblock() != null) {
            this.getMultiblock().tick(this.offset);
        } else if (this.ticks > 20L) {
            System.out.println("Error in multiblock, reverting");
            this.getWorld().breakBlock(this.getPos());
        }
    }

    public IBoundingBox getRenderBoundingBox() {
        return IBoundingBox.INFINITE;
    }

    public Vec3i getOrigin() {
        return this.getPos().subtract(this.offset.rotate(this.rotation));
    }

    public Multiblock.MultiblockInstance getMultiblock() {
        if (this.mb == null && this.isLoaded()) {
            this.mb = MultiblockRegistry.get(this.name).instance(this.getWorld(), this.getOrigin(), this.rotation);
        }
        return this.mb;
    }

    public String getName() {
        return this.name;
    }

    public long getRenderTicks() {
        return this.ticks;
    }

    public ItemStackHandler getContainer() {
        if (this.container.getSlotCount() != this.getMultiblock().getInvSize(this.offset)) {
            this.container.setSize(this.getMultiblock().getInvSize(this.offset));
        }
        return this.container;
    }

    public void breakBlock() {
        if (this.getMultiblock() != null) {
            this.getMultiblock().onBreak();
        }
    }

    public boolean onBlockActivated(Player player, Player.Hand hand) {
        return this.getMultiblock().onBlockActivated(player, hand, this.offset);
    }

    public void onBreakEvent() {
        for (int slot = 0; slot < this.container.getSlotCount(); ++slot) {
            ItemStack item = this.container.get(slot);
            if (item.isEmpty()) continue;
            this.getWorld().dropItem(item, this.getPos());
        }
        if (this.replaced != null) {
            this.getWorld().setBlock(this.getPos(), this.replaced);
        }
    }

    public boolean isRender() {
        return this.getMultiblock().isRender(this.offset);
    }

    public double getRotation() {
        return 180.0f - Facing.EAST.rotate(this.rotation).getAngle();
    }

    public int getCraftProgress() {
        return this.craftProgress;
    }

    public void setCraftProgress(int progress) {
        if (this.craftProgress != progress) {
            this.craftProgress = progress;
            this.markDirty();
        }
    }

    public CraftingMachineMode getCraftMode() {
        return this.craftMode;
    }

    public void setCraftMode(CraftingMachineMode mode) {
        if (this.getWorld().isServer) {
            if (this.craftMode != mode) {
                this.craftMode = mode;
                this.markDirty();
            }
        } else {
            new MultiblockSelectCraftPacket(this.getPos(), this.craftItem, mode).sendToServer();
        }
    }

    public ItemStack getCraftItem() {
        return this.craftItem;
    }

    public void setCraftItem(ItemStack selected) {
        if (this.getWorld().isServer) {
            if (selected == null || !selected.equals((Object)this.craftItem)) {
                this.craftItem = selected == null ? null : selected.copy();
                this.craftProgress = 0;
                this.markDirty();
            }
        } else {
            new MultiblockSelectCraftPacket(this.getPos(), selected, this.craftMode).sendToServer();
        }
    }

    public IInventory getInventory(Facing facing) {
        if (this.getMultiblock() == null || this.getMultiblock().getInvSize(this.offset) == 0) {
            return null;
        }
        if (this.container.getSlotCount() != this.getMultiblock().getInvSize(this.offset)) {
            this.container.setSize(this.getMultiblock().getInvSize(this.offset));
        }
        return new IInventory(){

            public int getSlotCount() {
                return TileMultiblock.this.container.getSlotCount();
            }

            public ItemStack get(int slot) {
                return TileMultiblock.this.container.get(slot);
            }

            public void set(int slot, ItemStack stack) {
                TileMultiblock.this.container.set(slot, stack);
            }

            public ItemStack insert(int slot, ItemStack stack, boolean simulate) {
                if (TileMultiblock.this.getMultiblock().canInsertItem(TileMultiblock.this.offset, slot, stack)) {
                    return TileMultiblock.this.container.insert(slot, stack, simulate);
                }
                return stack;
            }

            public ItemStack extract(int slot, int amount, boolean simulate) {
                if (TileMultiblock.this.getMultiblock().isOutputSlot(TileMultiblock.this.offset, slot)) {
                    return TileMultiblock.this.container.extract(slot, amount, simulate);
                }
                return ItemStack.EMPTY;
            }

            public int getLimit(int slot) {
                return TileMultiblock.this.container.getLimit(slot);
            }
        };
    }

    public IEnergy getEnergy(Facing facing) {
        return this.isLoaded() && this.getMultiblock().canRecievePower(this.offset) ? this.energy : null;
    }

    public void onBreak() {
        try {
            this.breakBlock();
        }
        catch (Exception ex) {
            ImmersiveRailroading.catching((Throwable)ex);
            this.getWorld().setToAir(this.getPos());
        }
    }

    public boolean onClick(Player player, Player.Hand hand, Facing facing, Vec3d hit) {
        return this.onBlockActivated(player, hand);
    }

    public ItemStack onPick() {
        return ItemStack.EMPTY;
    }
}

