/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.render;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.render.IArmorModelSpecNBT;
import lehjr.numina.common.capabilities.render.ModelSpecNBT;
import lehjr.numina.common.capabilities.render.modelspec.EnumSpecType;
import lehjr.numina.common.capabilities.render.modelspec.ModelPartSpec;
import lehjr.numina.common.capabilities.render.modelspec.ModelRegistry;
import lehjr.numina.common.capabilities.render.modelspec.ModelSpec;
import lehjr.numina.common.capabilities.render.modelspec.PartSpecBase;
import lehjr.numina.common.capabilities.render.modelspec.SpecBase;
import lehjr.numina.common.capabilities.render.modelspec.TexturePartSpec;
import lehjr.numina.common.tags.TagUtils;
import lehjr.powersuits.common.config.MPSSettings;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;

public class ArmorModelSpecNBT
extends ModelSpecNBT
implements IArmorModelSpecNBT {
    public ArmorModelSpecNBT(@Nonnull ItemStack itemStackIn) {
        super(itemStackIn);
    }

    public EnumSpecType getSpecType() {
        CompoundNBT renderTag = this.getRenderTag();
        if (renderTag == null || renderTag.isEmpty()) {
            renderTag = this.getDefaultRenderTag();
        }
        try {
            TexturePartSpec partSpec = (TexturePartSpec)ModelRegistry.getInstance().getPart(renderTag.func_74775_l("texSpec"));
            if (partSpec != null) {
                return EnumSpecType.ARMOR_SKIN;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String key : renderTag.func_150296_c()) {
            SpecBase testSpec;
            if (key.equals("colours") || !(renderTag.func_74781_a(key) instanceof CompoundNBT) || !((testSpec = ModelRegistry.getInstance().getModel(renderTag.func_74775_l(key))) instanceof ModelSpec)) continue;
            return EnumSpecType.ARMOR_MODEL;
        }
        return EnumSpecType.NONE;
    }

    public CompoundNBT getDefaultRenderTag() {
        if (this.getItemStack().func_190926_b()) {
            return new CompoundNBT();
        }
        ArrayList<CompoundNBT> prefArray = new ArrayList<CompoundNBT>();
        ListNBT specList = new ListNBT();
        CompoundNBT texSpecTag = new CompoundNBT();
        List colours = new ArrayList();
        EquipmentSlotType slot = MobEntity.func_184640_d((ItemStack)this.getItemStack());
        for (SpecBase spec : ModelRegistry.getInstance().getSpecs()) {
            if (!spec.isDefault() || !(this.getItemStack().func_77973_b() instanceof ArmorItem)) continue;
            colours = this.addNewColourstoList(colours, spec.getColours());
            if (spec.getSpecType().equals((Object)EnumSpecType.ARMOR_SKIN) && spec.get((Object)slot.func_188450_d()) != null) {
                texSpecTag = ((PartSpecBase)spec.get((Object)slot.func_188450_d())).multiSet(new CompoundNBT(), Integer.valueOf(this.getNewColourIndex(colours, spec.getColours(), ((PartSpecBase)spec.get((Object)slot.func_188450_d())).getDefaultColourIndex())));
                continue;
            }
            if (!spec.getSpecType().equals((Object)EnumSpecType.ARMOR_MODEL) || !MPSSettings.allowHighPollyArmor()) continue;
            for (PartSpecBase partSpec : spec.getPartSpecs()) {
                if (partSpec.getBinding().getSlot() != slot) continue;
                prefArray.add(((ModelPartSpec)partSpec).multiSet(new CompoundNBT(), Integer.valueOf(this.getNewColourIndex(colours, spec.getColours(), partSpec.getDefaultColourIndex())), Boolean.valueOf(((ModelPartSpec)partSpec).getGlow())));
            }
        }
        CompoundNBT nbt = new CompoundNBT();
        for (CompoundNBT elem : prefArray) {
            nbt.func_218657_a(elem.func_74779_i("model") + "." + elem.func_74779_i("part"), (INBT)elem);
        }
        if (!specList.isEmpty()) {
            nbt.func_218657_a("specList", (INBT)specList);
        }
        if (!texSpecTag.isEmpty()) {
            nbt.func_218657_a("texSpec", (INBT)texSpecTag);
        }
        nbt.func_218657_a("colours", (INBT)new IntArrayNBT(colours));
        return nbt;
    }

    public String getArmorTexture() {
        CompoundNBT itemTag = TagUtils.getMuseItemTag((ItemStack)this.getItemStack());
        CompoundNBT renderTag = itemTag.func_74775_l("render");
        try {
            TexturePartSpec partSpec = (TexturePartSpec)ModelRegistry.getInstance().getPart(renderTag.func_74775_l("texSpec"));
            return partSpec.getTextureLocation();
        }
        catch (Exception ignored) {
            return "numina:textures/item/armor/blankarmor.png";
        }
    }
}

