/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.block;

import javax.annotation.Nullable;
import lehjr.numina.common.math.Colour;
import lehjr.powersuits.common.blockentity.LuxCapacitorBlockEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ToolType;

public class LuxCapacitorBlock
extends DirectionalBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final Colour defaultColor = new Colour(0.4f, 0.2f, 0.9f);
    protected static final VoxelShape LUXCAPACITOR_EAST_AABB = Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0);
    protected static final VoxelShape LUXCAPACITOR_WEST_AABB = Block.func_208617_a((double)12.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    protected static final VoxelShape LUXCAPACITOR_SOUTH_AABB = Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)4.0);
    protected static final VoxelShape LUXCAPACITOR_NORTH_AABB = Block.func_208617_a((double)1.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0, (double)16.0);
    protected static final VoxelShape LUXCAPACITOR_UP_AABB = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    protected static final VoxelShape LUXCAPACITOR_DOWN_AABB = Block.func_208617_a((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public LuxCapacitorBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(0.05f, 10.0f).func_200947_a(SoundType.field_185852_e).func_208770_d().func_235838_a_(state -> 15));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176387_N, (Comparable)Direction.UP));
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return true;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        return Fluids.field_204541_a;
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    BlockPos relative(BlockPos pos, Direction direction) {
        return pos.func_177972_a(direction);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)context.func_196010_d().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction facing = state.func_235901_b_((Property)field_176387_N) ? (Direction)state.func_177229_b((Property)field_176387_N) : Direction.UP;
        return LuxCapacitorBlock.canSupportCenter(worldIn, pos.func_177972_a(facing.func_176734_d()), facing);
    }

    public static boolean canSupportCenter(IWorldReader world, BlockPos pos, Direction direction) {
        BlockState blockstate = world.func_180495_p(pos);
        return direction == Direction.DOWN && blockstate.func_235714_a_((ITag)BlockTags.field_232869_aB_) ? false : blockstate.func_242698_a((IBlockReader)world, pos, direction, BlockVoxelShape.CENTER);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)field_176387_N)) {
            default: {
                return LUXCAPACITOR_DOWN_AABB;
            }
            case UP: {
                return LUXCAPACITOR_UP_AABB;
            }
            case NORTH: {
                return LUXCAPACITOR_NORTH_AABB;
            }
            case SOUTH: {
                return LUXCAPACITOR_SOUTH_AABB;
            }
            case WEST: {
                return LUXCAPACITOR_WEST_AABB;
            }
            case EAST: 
        }
        return LUXCAPACITOR_EAST_AABB;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176387_N}).func_206894_a(new Property[]{WATERLOGGED});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new LuxCapacitorBlockEntity();
    }
}

