/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.armor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModule;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class NetheritePlatingModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        private final PowerModule powerModule;
        private final LazyOptional<IPowerModule> powerModuleHolder;
        ItemStack module;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.powerModule = new PowerModule(module, ModuleCategory.ARMOR, ModuleTarget.ARMORONLY, MPSSettings::getModuleConfig){
                {
                    super(arg0, arg1, arg2, arg3);
                    this.addBaseProperty("armorPhysical", 7.5, "module.tradeoff.armorPoints");
                    this.addBaseProperty("maxHeat", 750.0);
                    this.addBaseProperty("knockbackResistance", 1.5);
                    this.addBaseProperty("armorToughness", 3.5);
                }

                public int getTier() {
                    return 2;
                }

                public String getModuleGroup() {
                    return "Armor";
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> this.powerModule);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }
    }
}

