/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.weapon;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.module.rightclick.RightClickModule;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.numina.common.heat.HeatUtils;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class LightningModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        RightClickie rightClickie;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClickie = new RightClickie(module, ModuleCategory.WEAPON, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("lightningEnergyCon", 4900000.0, "FE");
                    this.addBaseProperty("heatEmission", 100.0, "");
                }
            };
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.rightClickie));
        }

        class RightClickie
        extends RightClickModule {
            public RightClickie(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public ActionResult use(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                int energyConsumption;
                if (hand == Hand.MAIN_HAND && (energyConsumption = this.getEnergyUsage()) < ElectricItemUtils.getPlayerEnergy((LivingEntity)playerIn)) {
                    double range;
                    RayTraceResult raytraceResult;
                    if (!worldIn.func_201670_d() && (raytraceResult = AbstractPowerModule.rayTrace(worldIn, playerIn, RayTraceContext.FluidMode.SOURCE_ONLY, range = 64.0)) != null && raytraceResult.func_216346_c() != RayTraceResult.Type.MISS && worldIn instanceof ServerWorld) {
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)playerIn, (int)energyConsumption);
                        HeatUtils.heatPlayer((LivingEntity)playerIn, (double)this.applyPropertyModifiers("heatEmission"));
                        LightningBoltEntity sparkie = new LightningBoltEntity(EntityType.field_200728_aG, worldIn);
                        sparkie.func_70107_b(raytraceResult.func_216347_e().field_72450_a, raytraceResult.func_216347_e().field_72448_b, raytraceResult.func_216347_e().field_72449_c);
                        sparkie.func_204809_d((ServerPlayerEntity)playerIn);
                        ((ServerWorld)worldIn).func_217440_f((Entity)sparkie);
                    }
                    return ActionResult.func_226248_a_((Object)itemStackIn);
                }
                return ActionResult.func_226250_c_((Object)itemStackIn);
            }

            public int getEnergyUsage() {
                return (int)Math.round(this.applyPropertyModifiers("lightningEnergyCon"));
            }
        }
    }
}

