/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.redstone;

import com.hrznstudio.titanium.api.IEnumValues;
import com.hrznstudio.titanium.api.redstone.IRedstoneAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class RedstoneManager<T extends IEnumValues<T> & IRedstoneAction>
implements INBTSerializable<CompoundNBT> {
    private T action;
    private boolean lastRedstoneState;
    private boolean shouldWork;

    public RedstoneManager(T defaultValue, boolean lastRedstoneState) {
        this.action = defaultValue;
        this.lastRedstoneState = lastRedstoneState;
        this.shouldWork = true;
    }

    public T getAction() {
        return this.action;
    }

    public void setAction(T action) {
        this.action = action;
    }

    public boolean getLastRedstoneState() {
        return this.lastRedstoneState;
    }

    public void setLastRedstoneState(boolean lastRedstoneState) {
        if (!this.lastRedstoneState && lastRedstoneState) {
            this.shouldWork = true;
        }
        this.lastRedstoneState = lastRedstoneState;
    }

    public boolean shouldWork() {
        return !((IRedstoneAction)this.action).startsOnChange() || this.shouldWork;
    }

    public void finish() {
        this.shouldWork = false;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT value = new CompoundNBT();
        value.func_74778_a("Name", ((IRedstoneAction)this.action).getName());
        value.func_74757_a("LastState", this.lastRedstoneState);
        return value;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.action = (IEnumValues)this.action.getValue(nbt.func_74779_i("Name"));
        this.lastRedstoneState = nbt.func_74767_n("LastState");
    }
}

