/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.common.init.ChiselTileEntities;

@ParametersAreNonnullByDefault
public class ContainerAutoChisel
extends Container {
    public final PlayerInventory invPlayer;
    private final int beginInputSlots;
    private final int endInputSlots;
    public final int chiselSlot;
    public final int targetSlot;
    private final int beginOutputSlots;
    private final int endOutputSlots;
    private final int beginPlayerSlots;
    private final int endPlayerSlots;
    private final IIntArray progressAndPower;
    private final IWorldPosCallable pos;
    public static final int ACTIVE = 0;
    public static final int PROGRESS = 1;
    public static final int MAX_PROGRESS = 2;
    public static final int ENERGY = 3;
    public static final int MAX_ENERGY = 4;
    public static final int ENERGY_USE = 5;

    public ContainerAutoChisel(ContainerType<ContainerAutoChisel> type, int windowId, PlayerInventory invPlayer) {
        this(type, windowId, invPlayer, (IItemHandler)new ItemStackHandler(12), (IItemHandler)new ItemStackHandler(12), (IItemHandler)new ItemStackHandler(2), (IIntArray)new IntArray(6), IWorldPosCallable.field_221489_a);
    }

    public ContainerAutoChisel(ContainerType<ContainerAutoChisel> type, int windowId, PlayerInventory invPlayer, IItemHandler input, IItemHandler output, IItemHandler other, IIntArray progressAndPower, IWorldPosCallable pos) {
        super(type, windowId);
        int i;
        this.invPlayer = invPlayer;
        int yStart = 19;
        this.chiselSlot = 0;
        this.func_75146_a((Slot)new SlotItemHandler(other, 0, 80, yStart + 9){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                return stack != null && stack.func_77973_b() instanceof IChiselItem;
            }
        });
        this.targetSlot = 1;
        this.func_75146_a((Slot)new ChiselableSlot(other, 1, 80, 54 + yStart - 9));
        this.beginInputSlots = this.field_75151_b.size();
        for (i = 0; i < input.getSlots(); ++i) {
            this.func_75146_a((Slot)new ChiselableSlot(input, i, 8 + 18 * (i % 3), yStart + 18 * (i / 3)));
        }
        this.endInputSlots = this.beginOutputSlots = this.field_75151_b.size();
        for (i = 0; i < output.getSlots(); ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(output, i, 116 + 18 * (i % 3), yStart + 18 * (i / 3)){

                public boolean func_75214_a(@Nullable ItemStack stack) {
                    return false;
                }
            });
        }
        this.beginPlayerSlots = this.endOutputSlots = this.field_75151_b.size();
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.func_75146_a(new Slot((IInventory)invPlayer, c + r * 9 + 9, 8 + c * 18, 118 + r * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)invPlayer, i, 8 + i * 18, 176));
        }
        this.endPlayerSlots = this.field_75151_b.size();
        ContainerAutoChisel.func_216959_a((IIntArray)progressAndPower, (int)2);
        this.func_216961_a(progressAndPower);
        this.progressAndPower = progressAndPower;
        this.pos = pos;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return ContainerAutoChisel.func_216963_a((IWorldPosCallable)this.pos, (PlayerEntity)playerIn, (Block)ChiselTileEntities.AUTO_CHISEL.get());
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index >= this.beginOutputSlots && index < this.endOutputSlots) {
                if (!this.func_75135_a(itemstack1, this.beginPlayerSlots, this.endPlayerSlots, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= this.beginPlayerSlots ? (CarvingUtils.getChiselRegistry().getGroup(itemstack1.func_77973_b()).isPresent() ? !this.func_75135_a(itemstack1, this.targetSlot, this.targetSlot + 1, false) && !this.func_75135_a(itemstack1, this.beginInputSlots, this.endInputSlots, false) : (itemstack1.func_77973_b() instanceof IChiselItem ? !this.func_75135_a(itemstack1, this.chiselSlot, this.chiselSlot + 1, false) : (index >= this.beginPlayerSlots && index < this.endPlayerSlots - 9 ? !this.func_75135_a(itemstack1, this.endPlayerSlots - 9, this.endPlayerSlots, false) : index >= this.endPlayerSlots - 9 && index < this.endPlayerSlots && !this.func_75135_a(itemstack1, 3, 30, false)))) : !this.func_75135_a(itemstack1, this.beginPlayerSlots, this.endPlayerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public boolean isActive() {
        return this.progressAndPower.func_221476_a(0) > 0;
    }

    public int getProgressScaled(int progBarLength) {
        return (int)((float)this.progressAndPower.func_221476_a(1) / (float)this.progressAndPower.func_221476_a(2) * (float)progBarLength);
    }

    public boolean hasEnergy() {
        return this.getEnergy() > 0;
    }

    public int getEnergy() {
        return this.progressAndPower.func_221476_a(3);
    }

    public int getMaxEnergy() {
        return this.progressAndPower.func_221476_a(4);
    }

    public int getEnergyScaled(int progBarLength) {
        return (int)((float)this.progressAndPower.func_221476_a(3) / (float)this.progressAndPower.func_221476_a(4) * (float)progBarLength);
    }

    public int getUsagePerTick() {
        return this.progressAndPower.func_221476_a(5);
    }

    private static class ChiselableSlot
    extends SlotItemHandler {
        public ChiselableSlot(IItemHandler inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nullable ItemStack stack) {
            return stack != null && CarvingUtils.getChiselRegistry().getGroup(stack.func_77973_b()).isPresent();
        }
    }
}

