/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.network.messages;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.client.HudOverlayHandler;
import de.srendi.advancedperipherals.common.argoggles.ARRenderAction;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateHudCanvasMessage {
    private static final String LIST = "list";
    private List<ARRenderAction> canvas;

    public UpdateHudCanvasMessage(List<ARRenderAction> canvas) {
        this.canvas = canvas;
    }

    public static UpdateHudCanvasMessage decode(PacketBuffer buf) {
        ByteBufInputStream streamin = new ByteBufInputStream((ByteBuf)buf);
        ArrayList<ARRenderAction> canvas = new ArrayList<ARRenderAction>();
        try {
            CompoundNBT nbt = CompressedStreamTools.func_152456_a((DataInput)streamin, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            ListNBT list = nbt.func_150295_c(LIST, 10);
            list.forEach(x -> canvas.add(ARRenderAction.deserialize((CompoundNBT)x)));
        }
        catch (IOException e) {
            AdvancedPeripherals.LOGGER.error("Failed to decode UpdateHudCanvasMessage: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return new UpdateHudCanvasMessage(canvas);
    }

    public static void encode(UpdateHudCanvasMessage mes, PacketBuffer buf) {
        ByteBufOutputStream stream = new ByteBufOutputStream((ByteBuf)buf);
        CompoundNBT nbt = new CompoundNBT();
        ListNBT list = new ListNBT();
        mes.getCanvas().forEach(x -> list.add((Object)x.serializeNBT()));
        nbt.func_218657_a(LIST, (INBT)list);
        try {
            CompressedStreamTools.func_74800_a((CompoundNBT)nbt, (DataOutput)stream);
        }
        catch (IOException e) {
            AdvancedPeripherals.LOGGER.error("Failed to encode UpdateHudCanvasMessage: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void handle(UpdateHudCanvasMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> HudOverlayHandler.updateCanvas(mes.getCanvas()));
        cont.get().setPacketHandled(true);
    }

    public List<ARRenderAction> getCanvas() {
        return this.canvas;
    }
}

