/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.Objects;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;

public class CokerUnitRecipeBuilder
extends IEFinishedRecipe<CokerUnitRecipeBuilder> {
    public static CokerUnitRecipeBuilder builder(ItemStack output, ITag.INamedTag<Fluid> outputFluid, int fluidOutAmount) {
        Objects.requireNonNull(output);
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("Input stack cannot be empty.");
        }
        return ((CokerUnitRecipeBuilder)new CokerUnitRecipeBuilder().addResult(output)).addOutputFluid(outputFluid, fluidOutAmount);
    }

    private CokerUnitRecipeBuilder() {
        super((IERecipeSerializer)Serializers.COKER_SERIALIZER.get());
    }

    public CokerUnitRecipeBuilder addInputItem(ITag.INamedTag<Item> item, int amount) {
        return (CokerUnitRecipeBuilder)this.addInput(new IngredientWithSize(item, amount));
    }

    public CokerUnitRecipeBuilder addInputFluid(ITag.INamedTag<Fluid> fluidTag, int amount) {
        return (CokerUnitRecipeBuilder)this.addFluidTag("inputfluid", new FluidTagInput(fluidTag.func_230234_a_(), amount));
    }

    public CokerUnitRecipeBuilder addOutputFluid(ITag.INamedTag<Fluid> fluidTag, int amount) {
        return (CokerUnitRecipeBuilder)this.addFluidTag("resultfluid", new FluidTagInput(fluidTag.func_230234_a_(), amount));
    }

    public CokerUnitRecipeBuilder setTimeAndEnergy(int time, int energy) {
        return (CokerUnitRecipeBuilder)((CokerUnitRecipeBuilder)this.setTime(time)).setEnergy(energy);
    }
}

