/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.jei;

import flaxbeard.immersivepetroleum.api.crafting.DistillationRecipe;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.compat.jei.IPRecipeCategory;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class DistillationRecipeCategory
extends IPRecipeCategory<DistillationRecipe> {
    public static final ResourceLocation ID = ResourceUtils.ip("distillation");
    private final IDrawableStatic tankOverlay;

    public DistillationRecipeCategory(IGuiHelper guiHelper) {
        super(DistillationRecipe.class, guiHelper, ID, "block.immersivepetroleum.distillationtower");
        ResourceLocation background = ResourceUtils.ip("textures/gui/distillation.png");
        this.setBackground(guiHelper.createDrawable(background, 51, 0, 81, 77));
        this.setIcon(new ItemStack((IItemProvider)IPContent.Multiblock.distillationtower));
        this.tankOverlay = guiHelper.createDrawable(background, 177, 31, 20, 51);
    }

    public void setIngredients(DistillationRecipe recipe, IIngredients ingredients) {
        ArrayList<FluidStack> out = new ArrayList<FluidStack>();
        for (FluidStack fluid : recipe.getFluidOutputs()) {
            if (fluid == null) continue;
            out.add(fluid);
        }
        ingredients.setInputs(VanillaTypes.FLUID, recipe.getInputFluid().getMatchingFluidStacks());
        ingredients.setOutputs(VanillaTypes.FLUID, out);
    }

    public void setRecipe(IRecipeLayout recipeLayout, DistillationRecipe recipe, IIngredients ingredients) {
        List list;
        int total;
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (recipe.getInputFluid() != null) {
            total = 0;
            list = recipe.getInputFluid().getMatchingFluidStacks();
            if (!list.isEmpty()) {
                for (FluidStack f : list) {
                    total += f.getAmount();
                }
            } else {
                total = 100;
            }
            guiFluidStacks.init(0, true, 9, 19, 20, 51, total, false, (IDrawable)this.tankOverlay);
            guiFluidStacks.set(0, list);
        }
        total = 0;
        list = recipe.getFluidOutputs();
        if (!list.isEmpty()) {
            for (FluidStack f : list) {
                total += f.getAmount();
            }
        } else {
            total = 100;
        }
        guiFluidStacks.init(1, false, 61, 21, 16, 47, total, false, null);
        guiFluidStacks.set(1, list);
    }
}

