/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import vazkii.quark.base.module.config.ConfigFlagManager;

public class FlagIngredient
extends Ingredient {
    private final Ingredient parent;
    private final String flag;

    public FlagIngredient(Ingredient parent, String flag) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.parent = parent;
        this.flag = flag;
    }

    private boolean isEnabled() {
        if (Serializer.INSTANCE == null) {
            return false;
        }
        return Serializer.INSTANCE.flagManager.getFlag(this.flag);
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (!this.isEnabled()) {
            return new ItemStack[0];
        }
        return this.parent.func_193365_a();
    }

    @Nonnull
    public IntList func_194139_b() {
        if (!this.isEnabled()) {
            return IntLists.EMPTY_LIST;
        }
        return this.parent.func_194139_b();
    }

    public boolean test(@Nullable ItemStack target) {
        if (target == null || !this.isEnabled()) {
            return false;
        }
        return this.parent.test(target);
    }

    protected void invalidate() {
    }

    public boolean isSimple() {
        return this.parent.isSimple();
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<FlagIngredient> {
        public static Serializer INSTANCE;
        private final ConfigFlagManager flagManager;

        public Serializer(ConfigFlagManager flagManager) {
            this.flagManager = flagManager;
            INSTANCE = this;
        }

        @Nonnull
        public FlagIngredient parse(@Nonnull PacketBuffer buffer) {
            return new FlagIngredient(Ingredient.func_199566_b((PacketBuffer)buffer), buffer.func_218666_n());
        }

        @Nonnull
        public FlagIngredient parse(@Nonnull JsonObject json) {
            Ingredient value = Ingredient.func_199802_a((JsonElement)json.get("value"));
            String flag = json.getAsJsonPrimitive("flag").getAsString();
            return new FlagIngredient(value, flag);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull FlagIngredient ingredient) {
            ingredient.parent.func_199564_a(buffer);
            buffer.func_180714_a(ingredient.flag);
        }
    }
}

