/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.pallet;

import java.util.UUID;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.experimental.pallet.PalletTileEntity;

public class PalletBlock
extends QuarkBlock {
    protected static final VoxelShape AABB = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);

    public PalletBlock(QuarkModule module) {
        super("pallet", module, ItemGroup.field_78031_c, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196663_cq));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof PalletTileEntity && !worldIn.field_72995_K && handIn == Hand.MAIN_HAND) {
            PalletTileEntity pallet = (PalletTileEntity)tile;
            String s = String.format("%d x [%s] max=%d/%d stack", pallet.count, pallet.stack, pallet.maxAcceptedCount, pallet.maxAcceptedCount / 64);
            player.func_145747_a((ITextComponent)new StringTextComponent(s), new UUID(12L, 12L));
            s = String.format("Inv = {%s,%s}", pallet.func_70301_a(0), pallet.func_70301_a(1));
            player.func_145747_a((ITextComponent)new StringTextComponent(s), new UUID(12L, 12L));
            pallet.sync();
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PalletTileEntity();
    }
}

