/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.subsets.SubsetsRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.EntryStackSubsetsMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubSubsetsMenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.Internal
public class Menu
extends WidgetWithBounds
implements LateRenderable {
    public static final UUID SUBSETS = UUID.randomUUID();
    public static final UUID WEATHER = UUID.randomUUID();
    public static final UUID GAME_TYPE = UUID.randomUUID();
    public final Point menuStartPoint;
    public final boolean facingRight;
    public final boolean facingDownwards;
    private final List<MenuEntry> entries = Lists.newArrayList();
    public final ScrollingContainer scrolling = new ScrollingContainer(){

        public int getMaxScrollHeight() {
            int i = 0;
            for (MenuEntry entry : Menu.this.func_231039_at__()) {
                i += entry.getEntryHeight();
            }
            return i;
        }

        public Rectangle getBounds() {
            return Menu.this.getInnerBounds();
        }

        public boolean hasScrollBar() {
            return Menu.this.hasScrollBar();
        }
    };

    public Menu(Rectangle menuStart, Collection<MenuEntry> entries, boolean sort) {
        this.buildEntries(entries, sort);
        int fullWidth = Minecraft.func_71410_x().field_71462_r.field_230708_k_;
        int fullHeight = Minecraft.func_71410_x().field_71462_r.field_230709_l_;
        boolean facingRight = true;
        this.facingDownwards = fullHeight - menuStart.getMaxY() > menuStart.y;
        int y = this.facingDownwards ? menuStart.getMaxY() : menuStart.y - (this.scrolling.getMaxScrollHeight() + 2);
        boolean hasScrollBar = this.scrolling.getMaxScrollHeight() > this.getInnerHeight(y);
        int menuWidth = this.getMaxEntryWidth() + 2 + (hasScrollBar ? 6 : 0);
        if (facingRight && fullWidth - menuStart.getMaxX() < menuWidth + 10) {
            facingRight = false;
        } else if (!facingRight && menuStart.x < menuWidth + 10) {
            facingRight = true;
        }
        this.facingRight = facingRight;
        int x = facingRight ? menuStart.x : menuStart.getMaxX() - (this.getMaxEntryWidth() + 2 + (hasScrollBar ? 6 : 0));
        this.menuStartPoint = new Point(x, y);
    }

    public static Menu createSubsetsMenuFromRegistry(Rectangle menuStart) {
        EntryRegistry instance = EntryRegistry.getInstance();
        List stacks = instance.getEntryStacks().collect(Collectors.toList());
        HashMap entries = Maps.newHashMap();
        Map<String, Object> allEntries = Menu.getOrCreateSubEntryInMap(entries, "roughlyenoughitems:all_entries");
        for (EntryStack stack : stacks) {
            Menu.putEntryInMap(allEntries, stack);
        }
        Map<String, Object> itemGroups = Menu.getOrCreateSubEntryInMap(entries, "roughlyenoughitems:item_groups");
        for (Item item : Registry.field_212630_s) {
            ItemGroup group = item.func_77640_w();
            if (group == null) continue;
            try {
                List<ItemStack> list = instance.appendStacksForItem(item);
                Map<String, Object> groupMenu = Menu.getOrCreateSubEntryInMap(itemGroups, "_item_group_" + group.field_78034_o);
                for (ItemStack stack : list) {
                    Menu.putEntryInMap(groupMenu, EntryStacks.of(stack));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Set<String> paths = SubsetsRegistry.getInstance().getPaths();
        for (String path : paths) {
            Map<Object, Object> lastMap = entries;
            String[] pathSegments = path.split("/");
            for (String pathSegment : pathSegments) {
                lastMap = Menu.getOrCreateSubEntryInMap(lastMap, pathSegment);
            }
            for (EntryStack entryStack : SubsetsRegistry.getInstance().getPathEntries(path)) {
                EntryStack<?> firstStack = CollectionUtils.findFirstOrNullEqualsExact(stacks, entryStack);
                if (firstStack == null) continue;
                Menu.putEntryInMap((Map<String, Object>)lastMap, firstStack);
            }
        }
        return new Menu(menuStart, Menu.buildEntries(entries), true);
    }

    private static Map<String, Object> getOrCreateSubEntryInMap(Map<String, Object> parent, String pathSegment) {
        Menu.putEntryInMap(parent, pathSegment);
        return (Map)parent.get(pathSegment);
    }

    private static void putEntryInMap(Map<String, Object> parent, String pathSegment) {
        if (!parent.containsKey(pathSegment)) {
            parent.put(pathSegment, Maps.newHashMap());
        }
    }

    private static void putEntryInMap(Map<String, Object> parent, EntryStack<?> stack) {
        Set items = (Set)parent.get("items");
        if (items == null) {
            items = Sets.newLinkedHashSet();
            parent.put("items", items);
        }
        items.add(stack);
    }

    private static List<MenuEntry> buildEntries(Map<String, Object> map) {
        ArrayList entries = Lists.newArrayList();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getKey().equals("items")) {
                Set items = (Set)entry.getValue();
                for (EntryStack item : items) {
                    entries.add(new EntryStackSubsetsMenuEntry(item));
                }
                continue;
            }
            Map entryMap = (Map)entry.getValue();
            if (entry.getKey().startsWith("_item_group_")) {
                entries.add(new SubSubsetsMenuEntry((ITextComponent)new TranslationTextComponent(entry.getKey().replace("_item_group_", "itemGroup.")), Menu.buildEntries(entryMap)));
                continue;
            }
            String translationKey = "subsets.rei." + entry.getKey().replace(':', '.');
            if (!I18n.func_188566_a((String)translationKey)) {
                RoughlyEnoughItemsCore.LOGGER.warn("Subsets menu " + translationKey + " does not have a translation");
            }
            entries.add(new SubSubsetsMenuEntry((ITextComponent)new TranslationTextComponent(translationKey), Menu.buildEntries(entryMap)));
        }
        return entries;
    }

    private void buildEntries(Collection<MenuEntry> entries, boolean sort) {
        this.entries.clear();
        this.entries.addAll(entries);
        if (sort) {
            this.entries.sort(Comparator.comparing(entry -> entry instanceof SubMenuEntry ? 0 : 1).thenComparing(entry -> entry instanceof SubMenuEntry ? ((SubMenuEntry)entry).text.getString() : ""));
        }
        for (MenuEntry entry2 : this.entries) {
            entry2.parent = this;
        }
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.menuStartPoint.x, this.menuStartPoint.y, this.getMaxEntryWidth() + 2 + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight(this.menuStartPoint.y) + 2);
    }

    public Rectangle getInnerBounds() {
        return new Rectangle(this.menuStartPoint.x + 1, this.menuStartPoint.y + 1, this.getMaxEntryWidth() + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight(this.menuStartPoint.y));
    }

    public boolean hasScrollBar() {
        return this.scrolling.getMaxScrollHeight() > this.getInnerHeight(this.menuStartPoint.y);
    }

    public int getInnerHeight(int y) {
        return Math.min(this.scrolling.getMaxScrollHeight(), this.minecraft.field_71462_r.field_230709_l_ - 20 - y);
    }

    public int getMaxEntryWidth() {
        int i = 0;
        for (MenuEntry entry : this.func_231039_at__()) {
            if (entry.getEntryWidth() <= i) continue;
            i = entry.getEntryWidth();
        }
        return Math.max(10, i);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        Rectangle bounds = this.getBounds();
        Rectangle innerBounds = this.getInnerBounds();
        Menu.func_238467_a_((MatrixStack)matrices, (int)bounds.x, (int)bounds.y, (int)bounds.getMaxX(), (int)bounds.getMaxY(), (int)(this.containsMouse(mouseX, mouseY) ? (REIRuntime.getInstance().isDarkThemeEnabled() ? -17587 : -1) : -6250336));
        Menu.func_238467_a_((MatrixStack)matrices, (int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)-16777216);
        boolean contains = innerBounds.contains(mouseX, mouseY);
        MenuEntry focused = this.func_241217_q_() instanceof MenuEntry ? (MenuEntry)this.func_241217_q_() : null;
        int currentY = innerBounds.y - this.scrolling.scrollAmountInt();
        for (MenuEntry child : this.func_231039_at__()) {
            boolean containsMouse;
            boolean bl = containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            if (containsMouse) {
                focused = child;
            }
            currentY += child.getEntryHeight();
        }
        currentY = innerBounds.y - this.scrolling.scrollAmountInt();
        ScissorsHandler.INSTANCE.scissor(this.scrolling.getScissorBounds());
        for (MenuEntry child : this.func_231039_at__()) {
            boolean rendering = currentY + child.getEntryHeight() >= innerBounds.y && currentY <= innerBounds.getMaxY();
            boolean containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            child.updateInformation(innerBounds.x, currentY, focused == child || containsMouse, containsMouse, rendering, this.getMaxEntryWidth());
            if (rendering) {
                child.func_230430_a_(matrices, mouseX, mouseY, delta);
            }
            currentY += child.getEntryHeight();
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.func_231035_a_((IGuiEventListener)focused);
        this.scrolling.renderScrollBar(0, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        this.scrolling.updatePosition(delta);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button) || this.getInnerBounds().contains(mouseX, mouseY);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.getInnerBounds().contains(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        for (MenuEntry child : this.func_231039_at__()) {
            if (!(child instanceof SubMenuEntry) || !child.func_231043_a_(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        if (super.containsMouse(mouseX, mouseY)) {
            return true;
        }
        for (MenuEntry child : this.func_231039_at__()) {
            if (!child.containsMouse(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public List<MenuEntry> func_231039_at__() {
        return this.entries;
    }
}

