/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class IdentifierArgumentType
extends ArgumentType<Unit, String> {
    public static final IdentifierArgumentType INSTANCE = new IdentifierArgumentType();
    private static final String EMPTY = "";
    private static final Style STYLE = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)9273069));

    @Override
    public String getName() {
        return "identifier";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "*";
    }

    @Override
    public Style getHighlightedStyle() {
        return STYLE;
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getIdentifierSearchMode();
    }

    @Override
    public String cacheData(EntryStack<?> stack) {
        String s;
        ResourceLocation identifier = stack.getIdentifier();
        if (identifier != null && !(s = identifier.func_110623_a()).isEmpty()) {
            return s;
        }
        return EMPTY;
    }

    @Override
    public boolean matches(String identifier, EntryStack<?> stack, String searchText, Unit filterData) {
        return !identifier.isEmpty() && identifier.contains(searchText);
    }

    @Override
    public Unit prepareSearchFilter(String searchText) {
        return Unit.INSTANCE;
    }

    private IdentifierArgumentType() {
    }
}

