/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.gui.hints.HintProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class PluginStageExecutionWatcher
implements HintProvider {
    private final Map<PluginManager<?>, PluginManagerData> allStages = new HashMap();
    private int lastStep;
    private Double lastProgress;

    public <T extends REIPlugin<?>> Reloadable<? extends T> reloadable(final PluginManager<?> manager) {
        return new Reloadable<T>(){

            private PluginManagerData data() {
                return PluginStageExecutionWatcher.this.allStages.computeIfAbsent(manager, PluginManagerData::new);
            }

            @Override
            public void startReload() {
                for (ReloadStage stage : ReloadStage.values()) {
                    this.startReload(stage);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startReload(ReloadStage stage) {
                Map map = PluginStageExecutionWatcher.this.allStages;
                synchronized (map) {
                    if (manager == PluginManager.getInstance() && stage.ordinal() == 0) {
                        PluginStageExecutionWatcher.this.allStages.clear();
                    }
                    this.data().beganStages.put(stage, new ArrayList());
                }
            }

            @Override
            public void endReload() {
                for (ReloadStage stage : ReloadStage.values()) {
                    this.endReload(stage);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void endReload(ReloadStage stage) {
                Map map = PluginStageExecutionWatcher.this.allStages;
                synchronized (map) {
                    this.data().finishedStages.add(stage);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void beforeReloadable(ReloadStage stage, Reloadable<T> other) {
                Map map = PluginStageExecutionWatcher.this.allStages;
                synchronized (map) {
                    ((List)this.data().beganStages.get((Object)stage)).add(other);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ReloadStage> notVisited() {
        Map<PluginManager<?>, PluginManagerData> map = this.allStages;
        synchronized (map) {
            HashSet<ReloadStage> notVisited = new HashSet<ReloadStage>(Arrays.asList(ReloadStage.values()));
            notVisited.removeIf(stage -> this.allStages.values().stream().allMatch(data -> ((PluginManagerData)data).finishedStages.contains(stage)));
            return notVisited;
        }
    }

    @Override
    public List<ITextComponent> provide() {
        List<ReloadStage> stages = Arrays.asList(ReloadStage.values());
        Set<ReloadStage> notVisited = this.notVisited();
        int allManagers = PluginManager.getActiveInstances().size();
        Pair[] progresses = new Pair[allManagers];
        Triple current = null;
        int i = 0;
        for (PluginManager<REIPlugin<?>> manager : PluginManager.getActiveInstances()) {
            boolean allDone;
            PluginManagerData data = this.allStages.get(manager);
            int index = i++;
            if (data == null) {
                progresses[index] = Pair.of((Object)0.0, (Object)0);
                continue;
            }
            boolean bl = allDone = data.finishedStages.size() == stages.size();
            if (allDone) {
                progresses[index] = Pair.of((Object)stages.size(), (Object)stages.size());
                continue;
            }
            MutablePair pair = new MutablePair((Object)0.0, (Object)0);
            for (ReloadStage reloadStage : stages) {
                List reloadables = (List)data.beganStages.get((Object)reloadStage);
                pair.setRight((Object)((Integer)pair.getRight() + 1));
                if (reloadables == null) continue;
                boolean finished = data.finishedStages.contains((Object)reloadStage);
                if (finished) {
                    pair.setLeft((Object)((Double)pair.getLeft() + 1.0));
                    continue;
                }
                pair.setLeft((Object)((Double)pair.getLeft() + (double)reloadables.size() / (double)manager.getReloadables().size()));
                if (reloadables.isEmpty()) continue;
                Reloadable currentReloadable = (Reloadable)Iterables.getLast((Iterable)reloadables);
                current = Triple.of(manager, (Object)((Object)reloadStage), (Object)currentReloadable);
            }
            for (Map.Entry entry : data.beganStages.entrySet()) {
                ReloadStage reloadStage = (ReloadStage)((Object)entry.getKey());
            }
            progresses[index] = pair;
        }
        if (notVisited.isEmpty()) {
            this.lastProgress = null;
            return Collections.emptyList();
        }
        double total = 0.0;
        boolean j = false;
        for (Pair pair : progresses) {
            total += pair == null || (Integer)pair.getRight() == 0 ? 0.0 : (Double)pair.getLeft() / (double)((Integer)pair.getRight()).intValue();
        }
        double average = total / (double)progresses.length;
        this.lastProgress = average;
        if (current != null) {
            int n = PluginManager.getActiveInstances().indexOf(current.getLeft());
            this.lastStep = n + 1 + ((ReloadStage)((Object)current.getMiddle())).ordinal() * allManagers;
        }
        String progress = String.format("Step %d/%d (%s%%):", this.lastStep, allManagers * stages.size(), Math.round(average * 100.0));
        String currentTask = current == null ? "Waiting" : PluginStageExecutionWatcher.getSimpleName(((Reloadable)current.getRight()).getClass());
        return ImmutableList.of((Object)new TranslationTextComponent("text.rei.not.fully.initialized"), (Object)new ImmutableTextComponent(progress), (Object)new ImmutableTextComponent(currentTask));
    }

    private static <P> String getSimpleName(Class<? extends P> clazz) {
        String name = clazz.getName();
        name = name.contains(".") ? StringUtils.substringAfterLast((String)name, (String)".") : name;
        name = name.replace("Impl", "");
        name = name.replace("$", ".");
        return name;
    }

    @Override
    @Nullable
    public Tooltip provideTooltip(Point mouse) {
        return Tooltip.create(mouse, new ITextComponent[]{new TranslationTextComponent("text.rei.not.fully.initialized.tooltip", new Object[]{this.notVisited().stream().map(Enum::name).collect(Collectors.joining(", "))})});
    }

    @Override
    @Nullable
    public Double getProgress() {
        return this.lastProgress;
    }

    @Override
    public Color getColor() {
        return Color.ofTransparent((int)1358894336);
    }

    private static class PluginManagerData {
        private final PluginManager<?> manager;
        private final Map<ReloadStage, List<Reloadable<?>>> beganStages = new HashMap();
        private final Set<ReloadStage> finishedStages = new HashSet<ReloadStage>();

        public PluginManagerData(PluginManager<?> manager) {
            this.manager = manager;
        }

        private void clear() {
            this.beganStages.clear();
            this.finishedStages.clear();
        }
    }
}

