/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DefaultCustomDisplay
extends DefaultCraftingDisplay<IRecipe<?>> {
    private int width;
    private int height;

    public DefaultCustomDisplay(@Nullable IRecipe<?> possibleRecipe, List<EntryIngredient> input, List<EntryIngredient> output) {
        this(null, possibleRecipe, input, output);
    }

    public DefaultCustomDisplay(@Nullable ResourceLocation location, @Nullable IRecipe<?> possibleRecipe, List<EntryIngredient> input, List<EntryIngredient> output) {
        super(input, output, Optional.ofNullable(location == null && possibleRecipe != null ? possibleRecipe.func_199560_c() : location), Optional.ofNullable(possibleRecipe));
        BitSet row = new BitSet(3);
        BitSet column = new BitSet(3);
        for (int i = 0; i < 9; ++i) {
            EntryIngredient stacks;
            if (i >= input.size() || !(stacks = input.get(i)).stream().anyMatch(stack -> !stack.isEmpty())) continue;
            row.set((i - i % 3) / 3);
            column.set(i % 3);
        }
        this.width = column.cardinality();
        this.height = row.cardinality();
    }

    public static DefaultCustomDisplay simple(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> location) {
        IRecipe optionalRecipe = location.flatMap(resourceLocation -> RecipeManagerContext.getInstance().getRecipeManager().func_215367_a(resourceLocation)).orElse(null);
        return new DefaultCustomDisplay(location.orElse(null), optionalRecipe, input, output);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getInputWidth() {
        return 3;
    }

    @Override
    public int getInputHeight() {
        return 3;
    }
}

