/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.api;

import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.util.OffsetItemUseContext;
import net.minecraft.block.SoundType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ItemMultiPart
extends Item {
    public ItemMultiPart(Item.Properties properties) {
        super(properties);
    }

    public abstract TMultiPart newPart(ItemUseContext var1);

    public ActionResultType func_195939_a(ItemUseContext context) {
        Vector3 vHit = new Vector3(context.func_221532_j()).subtract(context.func_195995_a());
        double hitDepth = ItemMultiPart.getHitDepth(vHit, context.func_196000_l().ordinal());
        if (hitDepth < 1.0 && this.place(context)) {
            return ActionResultType.SUCCESS;
        }
        return this.place(new OffsetItemUseContext(context)) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    private boolean place(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        TMultiPart part = this.newPart(context);
        if (part == null || !TileMultiPart.canPlacePart(context, part)) {
            return false;
        }
        if (!world.field_72995_K) {
            TileMultiPart.addPart(world, pos, part);
            SoundType sound = part.getPlacementSound(context);
            if (sound != null) {
                world.func_184133_a(null, pos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
            }
        }
        if (!context.func_195999_j().field_71075_bZ.field_75098_d) {
            context.func_195996_i().func_190918_g(1);
        }
        return true;
    }

    private static double getHitDepth(Vector3 vHit, int side) {
        return vHit.scalarProject(Rotation.axes[side]) + (double)(side % 2 ^ 1);
    }
}

