/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.block;

import codechicken.lib.raytracer.RayTracer;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.util.MultiPartLoadHandler;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockMultiPart
extends Block {
    public BlockMultiPart() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_208770_d().func_226896_b_());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MultiPartLoadHandler.TileNBTContainer();
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public boolean isAir(BlockState state, IBlockReader world, BlockPos pos) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        return tile == null || tile.getPartList().isEmpty();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        return tile == null ? VoxelShapes.func_197880_a() : tile.getShape(context);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        return tile == null ? VoxelShapes.func_197880_a() : tile.getCollisionShape(context);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        return tile == null ? VoxelShapes.func_197880_a() : tile.getRenderOcclusionShape();
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        return tile == null ? VoxelShapes.func_197880_a() : tile.getInteractionShape();
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader world, BlockPos pos) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        return tile == null ? VoxelShapes.func_197880_a() : tile.getBlockSupportShape();
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        return tile == null ? VoxelShapes.func_197880_a() : tile.getVisualShape(context);
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        if (tile != null) {
            return tile.getExplosionResistance(explosion);
        }
        return 0.0f;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        if (tile != null) {
            return tile.getLightValue();
        }
        return 0;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        PartRayTraceResult hit = BlockMultiPart.retracePart(world, pos, player);
        if (tile != null && hit != null) {
            return tile.getDestroyProgress(player, hit);
        }
        return 0.01f;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        PartRayTraceResult hit = BlockMultiPart.retracePart((IBlockReader)world, pos, player);
        world.func_217378_a(player, 2001, pos, Block.func_196246_j((BlockState)state));
        if (hit == null || tile == null) {
            BlockMultiPart.dropAndDestroy(world, pos);
            return true;
        }
        if (world.field_72995_K && tile.isClientTile()) {
            hit.part.addDestroyEffects(hit, Minecraft.func_71410_x().field_71452_i);
            return true;
        }
        tile.harvestPart(hit, player);
        return world.func_175625_s(pos) == null;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileMultiPart tile = BlockMultiPart.getTile((TileEntity)builder.func_216024_a(LootParameters.field_216288_h));
        if (tile != null) {
            return tile.getDrops();
        }
        return Collections.emptyList();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        PartRayTraceResult hit = BlockMultiPart.retracePart(world, pos, player);
        if (tile != null && hit != null) {
            return tile.getPickBlock(hit);
        }
        return ItemStack.field_190927_a;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit_) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        PartRayTraceResult hit = BlockMultiPart.retracePart((IBlockReader)world, pos, player);
        if (tile != null && hit != null) {
            return tile.use(player, hit, hand);
        }
        return ActionResultType.FAIL;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        PartRayTraceResult hit = BlockMultiPart.retracePart((IBlockReader)world, pos, player);
        if (tile != null && hit != null) {
            tile.attack(player, hit);
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        if (tile != null) {
            tile.entityInside(entity);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        if (tile != null) {
            tile.stepOn(entity);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        if (tile != null) {
            tile.onNeighborBlockChanged(fromPos);
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        if (tile != null) {
            tile.onNeighborTileChange(neighbor);
        }
    }

    public boolean getWeakChanges(BlockState state, IWorldReader world, BlockPos pos) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        if (tile != null) {
            return tile.getWeakChanges();
        }
        return false;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        if (tile != null) {
            return side != null && tile.canConnectRedstone(side.ordinal() ^ 1);
        }
        return false;
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        if (tile != null) {
            return tile.getDirectSignal(side.ordinal() ^ 1);
        }
        return 0;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        if (tile != null) {
            return tile.getSignal(side.ordinal() ^ 1);
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        if (tile != null) {
            tile.animateTick(rand);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult blockHit, ParticleManager manager) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, ((BlockRayTraceResult)blockHit).func_216350_a());
        if (tile != null && blockHit instanceof PartRayTraceResult) {
            PartRayTraceResult hit = (PartRayTraceResult)blockHit;
            hit.part.addHitEffects(hit, manager);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public static void dropAndDestroy(World world, BlockPos pos) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        if (tile != null && !world.field_72995_K) {
            tile.dropItems(tile.getDrops());
        }
        world.func_217377_a(pos, false);
    }

    public static TileMultiPart getTile(TileEntity tile) {
        if (tile instanceof TileMultiPart) {
            return (TileMultiPart)tile;
        }
        return null;
    }

    public static TileMultiPart getTile(IBlockReader world, BlockPos pos) {
        TileMultiPart t;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMultiPart && !(t = (TileMultiPart)tile).getPartList().isEmpty()) {
            return t;
        }
        return null;
    }

    public static TMultiPart getPart(IBlockReader world, BlockPos pos, int slot) {
        TileMultiPart tile = BlockMultiPart.getTile(world, pos);
        if (tile != null) {
            return tile.getSlottedPart(slot);
        }
        return null;
    }

    public static PartRayTraceResult retracePart(IBlockReader world, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult hit = RayTracer.retraceBlock((IBlockReader)world, (PlayerEntity)player, (BlockPos)pos);
        if (hit instanceof PartRayTraceResult) {
            return (PartRayTraceResult)hit;
        }
        return null;
    }
}

